/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.ByteList;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableByteStack;
import com.gs.collections.api.stack.primitive.MutableByteStack;
import com.gs.collections.impl.factory.primitive.ByteStacks;
import com.gs.collections.impl.iterator.UnmodifiableByteIterator;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveStack.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableByteStack
        implements MutableByteStack, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableByteStack stack;

    UnmodifiableByteStack(MutableByteStack stack)
    {
        this.stack = stack;
    }

    public void push(byte item)
    {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public byte pop()
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public ByteList pop(int count)
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public byte peek()
    {
        return this.stack.peek();
    }

    public ByteList peek(int count)
    {
        return this.stack.peek(count);
    }

    public byte peekAt(int index)
    {
        return this.stack.peekAt(index);
    }

    public int size()
    {
        return this.stack.size();
    }

    public boolean isEmpty()
    {
        return this.stack.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.stack.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(byte value)
    {
        return this.stack.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.stack.containsAll(source);
    }

    public ByteIterator byteIterator()
    {
        return new UnmodifiableByteIterator(this.stack.byteIterator());
    }

    public void forEach(ByteProcedure procedure)
    {
        this.stack.forEach(procedure);
    }

    public int count(BytePredicate predicate)
    {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.stack.noneSatisfy(predicate);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableByteStack select(BytePredicate predicate)
    {
        return this.stack.select(predicate);
    }

    public MutableByteStack reject(BytePredicate predicate)
    {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.stack.collect(function);
    }

    public long sum()
    {
        return this.stack.sum();
    }

    public byte max()
    {
        return this.stack.max();
    }

    public byte min()
    {
        return this.stack.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.stack.minIfEmpty(defaultValue);
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.stack.average();
    }

    public double median()
    {
        return this.stack.median();
    }

    public MutableByteList toSortedList()
    {
        return this.stack.toSortedList();
    }

    public byte[] toSortedArray()
    {
        return this.stack.toSortedArray();
    }

    public byte[] toArray()
    {
        return this.stack.toArray();
    }

    @Override
    public String toString()
    {
        return this.stack.toString();
    }

    public String makeString()
    {
        return this.stack.makeString();
    }

    public String makeString(String separator)
    {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableByteList toList()
    {
        return this.stack.toList();
    }

    public MutableByteSet toSet()
    {
        return this.stack.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack)
    {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode()
    {
        return this.stack.hashCode();
    }

    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    public MutableByteStack asUnmodifiable()
    {
        return this;
    }

    public MutableByteStack asSynchronized()
    {
        return new SynchronizedByteStack(this);
    }

    public ImmutableByteStack toImmutable()
    {
        return ByteStacks.immutable.withAllReversed(this);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return this.stack.injectInto(injectedValue, function);
    }
}
