/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.factory.bag.primitive.MutableFloatBagFactory;
import com.gs.collections.api.bag.primitive.MutableFloatBag;

/**
 * MutableFloatBagFactoryImpl is a factory implementation which creates instances of type {@link MutableFloatBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableFloatBagFactoryImpl implements MutableFloatBagFactory
{
    public MutableFloatBag empty()
    {
        return new FloatHashBag();
    }

    public MutableFloatBag of()
    {
        return this.empty();
    }

    public MutableFloatBag with()
    {
        return this.empty();
    }

    public MutableFloatBag of(float... items)
    {
        return this.with(items);
    }

    public MutableFloatBag with(float... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return FloatHashBag.newBagWith(items);
    }

    public MutableFloatBag ofAll(FloatIterable items)
    {
        return this.withAll(items);
    }

    public MutableFloatBag withAll(FloatIterable items)
    {
        return FloatHashBag.newBag(items);
    }
}
