/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.bag.primitive.MutableShortBagFactory;
import com.gs.collections.api.bag.primitive.MutableShortBag;

/**
 * MutableShortBagFactoryImpl is a factory implementation which creates instances of type {@link MutableShortBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableShortBagFactoryImpl implements MutableShortBagFactory
{
    public MutableShortBag empty()
    {
        return new ShortHashBag();
    }

    public MutableShortBag of()
    {
        return this.empty();
    }

    public MutableShortBag with()
    {
        return this.empty();
    }

    public MutableShortBag of(short... items)
    {
        return this.with(items);
    }

    public MutableShortBag with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return ShortHashBag.newBagWith(items);
    }

    public MutableShortBag ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public MutableShortBag withAll(ShortIterable items)
    {
        return ShortHashBag.newBag(items);
    }
}
