/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import java.util.Collection;
import java.util.Collections;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanIntProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedBooleanCollection;
import com.gs.collections.impl.factory.primitive.BooleanBags;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/**
 * A synchronized view of a {@link MutableBooleanBag}. It is imperative that the user manually synchronize on the collection when iterating over it using the
 * {@link BooleanIterator}, as per {@link Collections#synchronizedCollection(Collection)}.
 * <p>
 * This file was automatically generated from template file synchronizedPrimitiveBag.stg.
 *
 * @see MutableBooleanBag#asSynchronized()
 * @see MutableBag#asSynchronized()
 * @since 3.1.
 */
@ThreadSafe
public final class SynchronizedBooleanBag
        extends AbstractSynchronizedBooleanCollection
        implements MutableBooleanBag
{
    private static final long serialVersionUID = 1L;

    SynchronizedBooleanBag(MutableBooleanBag bag)
    {
        super(bag);
    }

    SynchronizedBooleanBag(MutableBooleanBag bag, Object newLock)
    {
        super(bag, newLock);
    }

    @GuardedBy("getLock()")
    private MutableBooleanBag getMutableBooleanBag()
    {
        return (MutableBooleanBag) this.getBooleanCollection();
    }

    @Override
    public SynchronizedBooleanBag with(boolean element)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanBag().add(element);
        }
        return this;
    }

    @Override
    public SynchronizedBooleanBag without(boolean element)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanBag().remove(element);
        }
        return this;
    }

    @Override
    public SynchronizedBooleanBag withAll(BooleanIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanBag().addAll(elements.toArray());
        }
        return this;
    }

    @Override
    public SynchronizedBooleanBag withoutAll(BooleanIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanBag().removeAll(elements);
        }
        return this;
    }

    public void addOccurrences(boolean item, int occurrences)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanBag().addOccurrences(item, occurrences);
        }
    }

    public boolean removeOccurrences(boolean item, int occurrences)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanBag().removeOccurrences(item, occurrences);
        }
    }

    public int sizeDistinct()
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanBag().sizeDistinct();
        }
    }

    public int occurrencesOf(boolean item)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanBag().occurrencesOf(item);
        }
    }

    public void forEachWithOccurrences(BooleanIntProcedure procedure)
    {
        synchronized (this.getLock())
        {
            this.getMutableBooleanBag().forEachWithOccurrences(procedure);
        }
    }

    @Override
    public MutableBooleanBag select(BooleanPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanBag().select(predicate);
        }
    }

    @Override
    public MutableBooleanBag reject(BooleanPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanBag().reject(predicate);
        }
    }

    @Override
    public <V> MutableBag<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanBag().collect(function);
        }
    }

    @Override
    public boolean equals(Object otherBag)
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanBag().equals(otherBag);
        }
    }

    @Override
    public int hashCode()
    {
        synchronized (this.getLock())
        {
            return this.getMutableBooleanBag().hashCode();
        }
    }

    @Override
    public LazyBooleanIterable asLazy()
    {
        synchronized (this.getLock())
        {
            return new LazyBooleanIterableAdapter(this);
        }
    }

    @Override
    public MutableBooleanBag asUnmodifiable()
    {
        return new UnmodifiableBooleanBag(this);
    }

    @Override
    public MutableBooleanBag asSynchronized()
    {
        return this;
    }

    @Override
    public ImmutableBooleanBag toImmutable()
    {
        return BooleanBags.immutable.withAll(this);
    }
}
