/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.collection.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.MutableCharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import net.jcip.annotations.ThreadSafe;

/**
 * This file was automatically generated from template file abstractUnmodifiablePrimitiveCollection.stg.
 *
 * @since 3.1.
 */
@ThreadSafe
public abstract class AbstractUnmodifiableCharCollection
        implements MutableCharCollection, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableCharCollection collection;

    protected AbstractUnmodifiableCharCollection(MutableCharCollection collection)
    {
        this.collection = collection;
    }

    protected MutableCharCollection getCharCollection()
    {
        return this.collection;
    }

    public int size()
    {
        return this.collection.size();
    }

    public boolean isEmpty()
    {
        return this.collection.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.collection.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(char value)
    {
        return this.collection.contains(value);
    }

    public boolean containsAll(char... source)
    {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(CharIterable source)
    {
        return this.collection.containsAll(source);
    }

    public boolean add(char newItem)
    {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(char... source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(CharIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean remove(char value)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(CharIterable source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(char... source)
    {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(CharIterable source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(char... source)
    {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public MutableCharIterator charIterator()
    {
        return new UnmodifiableCharIterator(this.collection.charIterator());
    }

    public void forEach(CharProcedure procedure)
    {
        this.collection.forEach(procedure);
    }

    public int count(CharPredicate predicate)
    {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableCharCollection select(CharPredicate predicate)
    {
        return this.collection.select(predicate);
    }

    public MutableCharCollection reject(CharPredicate predicate)
    {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.collection.collect(function);
    }

    public MutableCharCollection with(char element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableCharCollection without(char element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableCharCollection withAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableCharCollection withoutAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableCharCollection asUnmodifiable()
    {
        return this;
    }

    public MutableCharCollection asSynchronized()
    {
        return new SynchronizedCharCollection(this);
    }

    public ImmutableCharCollection toImmutable()
    {
        return this.collection.toImmutable();
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public long sum()
    {
        return this.collection.sum();
    }

    public char max()
    {
        return this.collection.max();
    }

    public char min()
    {
        return this.collection.min();
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.collection.minIfEmpty(defaultValue);
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.collection.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.collection.average();
    }

    public double median()
    {
        return this.collection.median();
    }

    public MutableCharList toSortedList()
    {
        return this.collection.toSortedList();
    }

    public char[] toSortedArray()
    {
        return this.collection.toSortedArray();
    }

    public char[] toArray()
    {
        return this.collection.toArray();
    }

    @Override
    public String toString()
    {
        return this.collection.toString();
    }

    public String makeString()
    {
        return this.collection.makeString();
    }

    public String makeString(String separator)
    {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableCharList toList()
    {
        return this.collection.toList();
    }

    public MutableCharSet toSet()
    {
        return this.collection.toSet();
    }

    public MutableCharBag toBag()
    {
        return this.collection.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return this.collection.injectInto(injectedValue, function);
    }
}
