/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.factory.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableShortByteMapFactory;
import com.gs.collections.api.factory.map.primitive.MutableShortByteMapFactory;
import com.gs.collections.impl.map.immutable.primitive.ImmutableShortByteMapFactoryImpl;
import com.gs.collections.impl.map.mutable.primitive.MutableShortByteMapFactoryImpl;

/**
 * ShortByteMaps is a static utility for creating {@link ImmutableShortByteMapFactory}.
 * This file was automatically generated from template file primitivePrimitiveMaps.stg.
 *
 * @since 4.0.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class ShortByteMaps
{
    public static final ImmutableShortByteMapFactory immutable = new ImmutableShortByteMapFactoryImpl();
    public static final MutableShortByteMapFactory mutable = new MutableShortByteMapFactoryImpl();

    private ShortByteMaps()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
