/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.block.factory.primitive.BytePredicates;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;

/**
 * This file was automatically generated from template file selectPrimitiveIterable.stg.
 */
public class SelectByteIterable
        extends AbstractLazyByteIterable
{
    private final ByteIterable delegate;
    private final BytePredicate predicate;

    public SelectByteIterable(ByteIterable delegate, BytePredicate predicate)
    {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public ByteIterator byteIterator()
    {
        return new SelectByteIterator(this.delegate, this.predicate);
    }

    public void forEach(ByteProcedure procedure)
    {
        this.delegate.forEach(new IfByteProcedure(procedure));
    }

    @Override
    public int size()
    {
        return this.delegate.count(this.predicate);
    }

    @Override
    public boolean isEmpty()
    {
        return !this.byteIterator().hasNext();
    }

    @Override
    public boolean notEmpty()
    {
        return this.byteIterator().hasNext();
    }

    @Override
    public int count(BytePredicate predicate)
    {
        CountByteProcedure countByteProcedure = new CountByteProcedure(predicate);
        this.forEach(countByteProcedure);
        return countByteProcedure.getCount();
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.delegate.anySatisfy(BytePredicates.and(this.predicate, predicate));
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.noneSatisfy(BytePredicates.not(predicate));
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate)
    {
        return !this.anySatisfy(predicate);
    }

    @Override
    public byte[] toArray()
    {
        final byte[] array = new byte[this.size()];
        this.forEach(new ByteProcedure()
        {
            @SuppressWarnings("FieldMayBeFinal")
            private int index = 0;
            public void value(byte each)
            {
                array[this.index++] = each;
            }
        });
        return array;
    }

    @Override
    public boolean containsAll(byte... source)
    {
        for (byte value : source)
        {
            if (!this.contains(value))
            {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source)
    {
        for (ByteIterator iterator = source.byteIterator(); iterator.hasNext(); )
        {
            if (!this.contains(iterator.next()))
            {
                return false;
            }
        }
        return true;
    }

    @Override
    public MutableByteList toList()
    {
        return ByteArrayList.newList(this);
    }

    @Override
    public MutableByteSet toSet()
    {
        return ByteHashSet.newSet(this);
    }

    @Override
    public MutableByteBag toBag()
    {
        return ByteHashBag.newBag(this);
    }

    private static final class CountByteProcedure implements ByteProcedure
    {
        private static final long serialVersionUID = 1L;
        private final BytePredicate predicate;
        private int counter = 0;

        private CountByteProcedure(BytePredicate predicate)
        {
            this.predicate = predicate;
        }

        public void value(byte each)
        {
            if (this.predicate.accept(each))
            {
                this.counter++;
            }
        }

        public int getCount()
        {
            return this.counter;
        }
    }

    private final class IfByteProcedure implements ByteProcedure
    {
        private static final long serialVersionUID = 1L;
        private final ByteProcedure procedure;

        private IfByteProcedure(ByteProcedure procedure)
        {
            this.procedure = procedure;
        }

        public void value(byte each)
        {
            if (SelectByteIterable.this.predicate.accept(each))
            {
                this.procedure.value(each);
            }
        }
    }

    private static final class SelectByteIterator
            implements ByteIterator
    {
        private final ByteIterator iterator;
        private final BytePredicate predicate;
        private byte next;
        private boolean verifiedHasNext = false;

        private SelectByteIterator(ByteIterable iterable, BytePredicate predicate)
        {
            this(iterable.byteIterator(), predicate);
        }

        private SelectByteIterator(ByteIterator iterator, BytePredicate predicate)
        {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext()
        {
            if (this.verifiedHasNext)
            {
                return true;
            }
            while (this.iterator.hasNext())
            {
                byte temp = this.iterator.next();
                if (this.predicate.accept(temp))
                {
                    this.next = temp;
                    this.verifiedHasNext = true;
                    return true;
                }
            }
            return false;
        }

        public byte next()
        {
            if (this.verifiedHasNext || this.hasNext())
            {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }
}
