/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableShortListFactory;
import com.gs.collections.api.list.primitive.ImmutableShortList;

/**
 * ImmutableShortListFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortList}.
 * This file was automatically generated from template file immutablePrimitiveListFactoryImpl.stg.
 *
 * @since 3.2.
 */
public class ImmutableShortListFactoryImpl implements ImmutableShortListFactory
{
    public ImmutableShortList empty()
    {
        return ImmutableShortEmptyList.INSTANCE;
    }

    public ImmutableShortList of()
    {
        return this.empty();
    }

    public ImmutableShortList with()
    {
        return this.empty();
    }

    public ImmutableShortList of(short one)
    {
        return this.with(one);
    }

    public ImmutableShortList with(short one)
    {
        return new ImmutableShortSingletonList(one);
    }

    public ImmutableShortList of(short... items)
    {
        return this.with(items);
    }

    public ImmutableShortList with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableShortArrayList.newListWith(items);
    }

    public ImmutableShortList ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableShortList withAll(ShortIterable items)
    {
        if (items instanceof ImmutableShortList)
        {
            return (ImmutableShortList) items;
        }
        return this.with(items.toArray());
    }
}
