/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.list.primitive.MutableLongListFactory;
import com.gs.collections.api.list.primitive.MutableLongList;

/**
 * MutableLongListFactoryImpl is a factory implementation which creates instances of type {@link MutableLongList}.
 * This file was automatically generated from template file mutablePrimitiveListFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableLongListFactoryImpl implements MutableLongListFactory
{
    public MutableLongList empty()
    {
        return new LongArrayList();
    }

    public MutableLongList of()
    {
        return this.empty();
    }

    public MutableLongList with()
    {
        return this.empty();
    }

    public MutableLongList of(long... items)
    {
        return this.with(items);
    }

    public MutableLongList with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return LongArrayList.newListWith(items);
    }

    public MutableLongList ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public MutableLongList withAll(LongIterable items)
    {
        return LongArrayList.newList(items);
    }
}
