/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableByteDoubleMapFactory;
import com.gs.collections.api.map.primitive.ImmutableByteDoubleMap;
import com.gs.collections.api.map.primitive.ByteDoubleMap;

/**
 * ImmutableByteDoubleMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteDoubleMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteDoubleMapFactoryImpl implements ImmutableByteDoubleMapFactory
{
    public ImmutableByteDoubleMap empty()
    {
        return ImmutableByteDoubleEmptyMap.INSTANCE;
    }

    public ImmutableByteDoubleMap of()
    {
        return this.empty();
    }

    public ImmutableByteDoubleMap with()
    {
        return this.empty();
    }

    public ImmutableByteDoubleMap of(byte key, double value)
    {
        return this.with(key, value);
    }

    public ImmutableByteDoubleMap with(byte key, double value)
    {
        return new ImmutableByteDoubleSingletonMap(key, value);
    }

    public ImmutableByteDoubleMap ofAll(ByteDoubleMap map)
    {
        return this.withAll(map);
    }

    public ImmutableByteDoubleMap withAll(ByteDoubleMap map)
    {
        if (map instanceof ImmutableByteDoubleMap)
        {
            return (ImmutableByteDoubleMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableByteDoubleHashMap(map);
    }
}
