/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableFloatBooleanMapFactory;
import com.gs.collections.api.map.primitive.ImmutableFloatBooleanMap;
import com.gs.collections.api.map.primitive.FloatBooleanMap;

/**
 * ImmutableFloatBooleanMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatBooleanMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatBooleanMapFactoryImpl implements ImmutableFloatBooleanMapFactory
{
    public ImmutableFloatBooleanMap empty()
    {
        return ImmutableFloatBooleanEmptyMap.INSTANCE;
    }

    public ImmutableFloatBooleanMap of()
    {
        return this.empty();
    }

    public ImmutableFloatBooleanMap with()
    {
        return this.empty();
    }

    public ImmutableFloatBooleanMap of(float key, boolean value)
    {
        return this.with(key, value);
    }

    public ImmutableFloatBooleanMap with(float key, boolean value)
    {
        return new ImmutableFloatBooleanSingletonMap(key, value);
    }

    public ImmutableFloatBooleanMap ofAll(FloatBooleanMap map)
    {
        return this.withAll(map);
    }

    public ImmutableFloatBooleanMap withAll(FloatBooleanMap map)
    {
        if (map instanceof ImmutableFloatBooleanMap)
        {
            return (ImmutableFloatBooleanMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatBooleanSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatBooleanHashMap(map);
    }
}
