/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableLongCharMapFactory;
import com.gs.collections.api.map.primitive.ImmutableLongCharMap;
import com.gs.collections.api.map.primitive.LongCharMap;

/**
 * ImmutableLongCharMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongCharMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongCharMapFactoryImpl implements ImmutableLongCharMapFactory
{
    public ImmutableLongCharMap empty()
    {
        return ImmutableLongCharEmptyMap.INSTANCE;
    }

    public ImmutableLongCharMap of()
    {
        return this.empty();
    }

    public ImmutableLongCharMap with()
    {
        return this.empty();
    }

    public ImmutableLongCharMap of(long key, char value)
    {
        return this.with(key, value);
    }

    public ImmutableLongCharMap with(long key, char value)
    {
        return new ImmutableLongCharSingletonMap(key, value);
    }

    public ImmutableLongCharMap ofAll(LongCharMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongCharMap withAll(LongCharMap map)
    {
        if (map instanceof ImmutableLongCharMap)
        {
            return (ImmutableLongCharMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongCharSingletonMap(key, map.get(key));
        }
        return new ImmutableLongCharHashMap(map);
    }
}
