/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleToLongFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleLongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleLongProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.MutableLongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableDoubleLongMap;
import com.gs.collections.api.map.primitive.DoubleLongMap;
import com.gs.collections.api.map.primitive.MutableDoubleLongMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.DoubleLongPair;
import com.gs.collections.impl.factory.primitive.DoubleLongMaps;
import com.gs.collections.impl.iterator.UnmodifiableLongIterator;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableDoubleLongMap
        implements MutableDoubleLongMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableDoubleLongMap map;

    UnmodifiableDoubleLongMap(MutableDoubleLongMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(double key, long value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(DoubleLongMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(double key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(double key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public long removeKeyIfAbsent(double key, long value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public long getIfAbsentPut(double key, long value)
    {
        return this.map.getIfAbsentPut(key, new LongFunction0()
        {
            public long value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public long getIfAbsentPut(double key, LongFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new LongFunction0()
        {
            public long value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public long getIfAbsentPutWithKey(double key, DoubleToLongFunction function)
    {
        return this.map.getIfAbsentPut(key, new LongFunction0()
        {
            public long value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> long getIfAbsentPutWith(double key, LongFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new LongFunction0()
        {
            public long value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public long updateValue(double key, long initialValueIfAbsent, LongToLongFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public long get(double key)
    {
        return this.map.get(key);
    }

    public long getIfAbsent(double key, long ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(double key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(double key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(long value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleLongProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<DoubleLongPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableDoubleLongMap select(DoubleLongPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableDoubleLongMap reject(DoubleLongPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableLongIterator longIterator()
    {
        return new UnmodifiableLongIterator(this.map.longIterator());
    }

    public void forEach(LongProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(LongPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableLongCollection select(LongPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableLongCollection reject(LongPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public long max()
    {
        return this.map.max();
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public long min()
    {
        return this.map.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public long addToValue(double key, long toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public long[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableLongList toSortedList()
    {
        return this.map.toSortedList();
    }

    public long[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(long value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableLongList toList()
    {
        return this.map.toList();
    }

    public MutableLongSet toSet()
    {
        return this.map.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.map.toBag();
    }

    public LazyLongIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableDoubleLongMap withKeyValue(double key, long value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleLongMap withoutKey(double key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleLongMap withoutAllKeys(DoubleIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleLongMap asUnmodifiable()
    {
        return this;
    }

    public MutableDoubleLongMap asSynchronized()
    {
        return new SynchronizedDoubleLongMap(this);
    }

    public ImmutableDoubleLongMap toImmutable()
    {
        return DoubleLongMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(this.map.keySet());
    }

    public MutableLongCollection values()
    {
        return UnmodifiableLongCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
