/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package package contains the implementations of {@link com.gs.collections.api.set.ImmutableSet}.
 * <p>
 *     This package contains the following immutable set implementations:
 * <ul>
 *     <li>
 *          {@link com.gs.collections.impl.set.immutable.ImmutableEmptySet} - an immutable set with 0 elements.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.impl.set.immutable.ImmutableSingletonSet} - an immutable set with 1 element.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.impl.set.immutable.ImmutableDoubletonSet} - an immutable set with 2 elements.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.impl.set.immutable.ImmutableTripletonSet} - an immutable set with 3 elements.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.impl.set.immutable.ImmutableQuadrupletonSet} - an immutable set with 4 elements.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.impl.set.immutable.ImmutableUnifiedSet} - the non-modifiable equivalent of {@link com.gs.collections.impl.set.mutable.UnifiedSet}.
 *     </li>
 * </ul>
 * <p>
 *     This package contains one factory implementation:
 * <ul>
 *     <li>
 *          {@link com.gs.collections.impl.set.immutable.ImmutableSetFactoryImpl} - a factory which creates instances of type {@link com.gs.collections.api.set.ImmutableSet}.
 *     </li>
 * </ul>
 */
package com.gs.collections.impl.set.immutable;
