/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableCharStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableCharStack;

/**
 * ImmutableCharStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharStackFactoryImpl implements ImmutableCharStackFactory
{
    public ImmutableCharStack empty()
    {
        return ImmutableCharEmptyStack.INSTANCE;
    }

    public ImmutableCharStack of()
    {
        return this.empty();
    }

    public ImmutableCharStack with()
    {
        return this.empty();
    }

    public ImmutableCharStack of(char one)
    {
        return this.with(one);
    }

    public ImmutableCharStack with(char one)
    {
        return new ImmutableCharSingletonStack(one);
    }

    public ImmutableCharStack of(char... items)
    {
        return this.with(items);
    }

    public ImmutableCharStack with(char... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableCharArrayStack.newStackWith(items);
    }

    public ImmutableCharStack ofAll(CharIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableCharStack withAll(CharIterable items)
    {
        if (items instanceof ImmutableCharStack)
        {
            return (ImmutableCharStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableCharStack ofAllReversed(CharIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableCharStack withAllReversed(CharIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableCharArrayStack.newStackFromTopToBottom(items);
    }
}
