/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableLongStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableLongStack;

/**
 * ImmutableLongStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongStackFactoryImpl implements ImmutableLongStackFactory
{
    public ImmutableLongStack empty()
    {
        return ImmutableLongEmptyStack.INSTANCE;
    }

    public ImmutableLongStack of()
    {
        return this.empty();
    }

    public ImmutableLongStack with()
    {
        return this.empty();
    }

    public ImmutableLongStack of(long one)
    {
        return this.with(one);
    }

    public ImmutableLongStack with(long one)
    {
        return new ImmutableLongSingletonStack(one);
    }

    public ImmutableLongStack of(long... items)
    {
        return this.with(items);
    }

    public ImmutableLongStack with(long... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableLongArrayStack.newStackWith(items);
    }

    public ImmutableLongStack ofAll(LongIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableLongStack withAll(LongIterable items)
    {
        if (items instanceof ImmutableLongStack)
        {
            return (ImmutableLongStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableLongStack ofAllReversed(LongIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableLongStack withAllReversed(LongIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableLongArrayStack.newStackFromTopToBottom(items);
    }
}
