/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.stack.primitive.MutableShortStackFactory;
import com.gs.collections.api.stack.primitive.MutableShortStack;

/**
 * MutableShortStackFactoryImpl is a factory implementation which creates instances of type {@link MutableShortStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableShortStackFactoryImpl implements MutableShortStackFactory
{
    public MutableShortStack empty()
    {
        return new ShortArrayStack();
    }

    public MutableShortStack of()
    {
        return this.empty();
    }

    public MutableShortStack with()
    {
        return this.empty();
    }

    public MutableShortStack of(short... items)
    {
        return this.with(items);
    }

    public MutableShortStack with(short... items)
    {
        if (items.length == 0)
        {
            return this.empty();
        }
        return ShortArrayStack.newStackWith(items);
    }

    public MutableShortStack ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public MutableShortStack withAll(ShortIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return ShortArrayStack.newStack(items);
    }

    public MutableShortStack ofAllReversed(ShortIterable items)
    {
        return this.withAllReversed(items);
    }

    public MutableShortStack withAllReversed(ShortIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return ShortArrayStack.newStackFromTopToBottom(items);
    }
}
