/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.utility.internal.primitive;

import java.io.IOException;
import java.util.Collection;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;

/**
 * This file was automatically generated from template file primitiveIterableIterate.stg.
 *
 * @since 5.0
 */
public final class IntIterableIterate
{
    private IntIterableIterate()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }

    public static boolean isEmpty(IntIterable iterable)
    {
        return !iterable.intIterator().hasNext();
    }

    public static boolean notEmpty(IntIterable iterable)
    {
        return !IntIterableIterate.isEmpty(iterable);
    }

    public static void forEach(IntIterable iterable, IntProcedure procedure)
    {
        IntIteratorIterate.forEach(iterable.intIterator(), procedure);
    }

    public static <R extends MutableIntCollection> R select(IntIterable iterable, IntPredicate predicate, R targetCollection)
    {
        return IntIteratorIterate.select(iterable.intIterator(), predicate, targetCollection);
    }

    public static <R extends MutableIntCollection> R reject(IntIterable iterable, IntPredicate predicate, R targetCollection)
    {
        return IntIteratorIterate.reject(iterable.intIterator(), predicate, targetCollection);
    }

    public static <V, R extends Collection<V>> R collect(
            IntIterable iterable,
            IntToObjectFunction<? extends V> function,
            R targetCollection)
    {
        return IntIteratorIterate.collect(iterable.intIterator(), function, targetCollection);
    }

    public static int detectIfNone(IntIterable iterable, IntPredicate predicate, int ifNone)
    {
        return IntIteratorIterate.detectIfNone(iterable.intIterator(), predicate, ifNone);
    }

    public static int count(IntIterable iterable, IntPredicate predicate)
    {
        return IntIteratorIterate.count(iterable.intIterator(), predicate);
    }

    public static boolean anySatisfy(IntIterable iterable, IntPredicate predicate)
    {
        return IntIteratorIterate.anySatisfy(iterable.intIterator(), predicate);
    }

    public static boolean allSatisfy(IntIterable iterable, IntPredicate predicate)
    {
        return IntIteratorIterate.allSatisfy(iterable.intIterator(), predicate);
    }

    public static boolean noneSatisfy(IntIterable iterable, IntPredicate predicate)
    {
        return IntIteratorIterate.noneSatisfy(iterable.intIterator(), predicate);
    }

    public static long sum(IntIterable iterable)
    {
        return IntIteratorIterate.sum(iterable.intIterator());
    }

    public static int max(IntIterable iterable)
    {
        return IntIteratorIterate.max(iterable.intIterator());
    }

    public static int maxIfEmpty(IntIterable iterable, int ifEmpty)
    {
        if (IntIterableIterate.isEmpty(iterable))
        {
            return ifEmpty;
        }
        return IntIteratorIterate.max(iterable.intIterator());
    }

    public static int min(IntIterable iterable)
    {
        return IntIteratorIterate.min(iterable.intIterator());
    }

    public static int minIfEmpty(IntIterable iterable, int ifEmpty)
    {
        if (IntIterableIterate.isEmpty(iterable))
        {
            return ifEmpty;
        }
        return IntIteratorIterate.min(iterable.intIterator());
    }

    public static void appendString(
            IntIterable iterable,
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        try
        {
            appendable.append(start);

            IntIterator iterator = iterable.intIterator();
            if (iterator.hasNext())
            {
                appendable.append(stringValueOfItem(iterable, iterator.next()));
                while (iterator.hasNext())
                {
                    appendable.append(separator);
                    appendable.append(stringValueOfItem(iterable, iterator.next()));
                }
            }

            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public static <T> T injectInto(IntIterable iterable, T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return IntIteratorIterate.injectInto(iterable.intIterator(), injectedValue, function);
    }

    private static <T> String stringValueOfItem(IntIterable iterable, T item)
    {
        return item == iterable
                ? "(this " + iterable.getClass().getSimpleName() + ')'
                : String.valueOf(item);
    }
}
