/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.block.factory.primitive.LongPredicates;
import com.gs.collections.impl.factory.primitive.LongSets;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.utility.internal.primitive.LongIterableIterate;
import com.gs.collections.impl.utility.primitive.LazyLongIterate;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLazyLongIterable
implements LazyLongIterable {
    public int size() {
        return this.count(LongPredicates.alwaysTrue());
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty() {
        return LongIterableIterate.isEmpty((LongIterable)this);
    }

    public boolean notEmpty() {
        return LongIterableIterate.notEmpty((LongIterable)this);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        LongIterableIterate.appendString((LongIterable)this, appendable, start, separator, end);
    }

    public boolean contains(long value) {
        return this.anySatisfy(LongPredicates.equal(value));
    }

    public boolean containsAll(long ... source) {
        return this.containsAll((LongIterable)LongSets.immutable.of(source));
    }

    public boolean containsAll(LongIterable source) {
        return source.allSatisfy(new LongPredicate(){

            public boolean accept(long value) {
                return AbstractLazyLongIterable.this.contains(value);
            }
        });
    }

    public LazyLongIterable select(LongPredicate predicate) {
        return LazyLongIterate.select((LongIterable)this, predicate);
    }

    public LazyLongIterable reject(LongPredicate predicate) {
        return LazyLongIterate.select((LongIterable)this, LongPredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(LongToObjectFunction<? extends V> function) {
        return LazyLongIterate.collect((LongIterable)this, function);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return LongIterableIterate.detectIfNone((LongIterable)this, predicate, ifNone);
    }

    public int count(LongPredicate predicate) {
        return LongIterableIterate.count((LongIterable)this, predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return LongIterableIterate.anySatisfy((LongIterable)this, predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return LongIterableIterate.allSatisfy((LongIterable)this, predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return LongIterableIterate.noneSatisfy((LongIterable)this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return LongIterableIterate.injectInto((LongIterable)this, injectedValue, function);
    }

    public long[] toArray() {
        return this.toList().toArray();
    }

    public MutableLongList toList() {
        final LongArrayList list = new LongArrayList();
        this.forEach(new LongProcedure(){

            public void value(long each) {
                list.add(each);
            }
        });
        return list;
    }

    public MutableLongSet toSet() {
        final LongHashSet set = new LongHashSet();
        this.forEach(new LongProcedure(){

            public void value(long each) {
                set.add(each);
            }
        });
        return set;
    }

    public MutableLongBag toBag() {
        final LongHashBag bag = new LongHashBag();
        this.forEach(new LongProcedure(){

            public void value(long each) {
                bag.add(each);
            }
        });
        return bag;
    }

    public long sum() {
        LongSumProcedure procedure = new LongSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongMaxProcedure procedure = new LongMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public long maxIfEmpty(long ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.max();
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        LongMinProcedure procedure = new LongMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public long minIfEmpty(long ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public long[] toSortedArray() {
        return this.toSortedList().toArray();
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newList((LongIterable)this).sortThis();
    }

    public LazyLongIterable asLazy() {
        return this;
    }

    private static final class LongSumProcedure
    implements LongProcedure {
        private long sum = 0L;

        private LongSumProcedure() {
        }

        public void value(long each) {
            this.sum += each;
        }

        public long getValue() {
            return this.sum;
        }
    }

    private static final class LongMinProcedure
    implements LongProcedure {
        private boolean visitedOnce;
        private long min;

        private LongMinProcedure() {
        }

        public void value(long each) {
            if (this.visitedOnce) {
                if (each < this.min) {
                    this.min = each;
                }
            } else {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public long getValue() {
            return this.min;
        }
    }

    private static final class LongMaxProcedure
    implements LongProcedure {
        private boolean visitedOnce;
        private long max;

        private LongMaxProcedure() {
        }

        public void value(long each) {
            if (this.visitedOnce) {
                if (this.max < each) {
                    this.max = each;
                }
            } else {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public long getValue() {
            return this.max;
        }
    }
}

