/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.list.primitive.ShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.util.NoSuchElementException;

public class ReverseShortIterable
extends AbstractLazyShortIterable {
    private final ShortList adapted;

    public ReverseShortIterable(ShortList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseShortIterable adapt(ShortList shortList) {
        return new ReverseShortIterable(shortList);
    }

    public ShortIterator shortIterator() {
        return new ReverseShortIterator();
    }

    public void forEach(ShortProcedure procedure) {
        ShortIterator iterator = this.shortIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public long sum() {
        return this.adapted.sum();
    }

    public short max() {
        return this.adapted.max();
    }

    public short min() {
        return this.adapted.min();
    }

    public short minIfEmpty(short defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public short maxIfEmpty(short defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public short[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public short[] toArray() {
        short[] results = new short[this.adapted.size()];
        int index = 0;
        ShortIterator iterator = this.shortIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    public boolean contains(short value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableShortList toList() {
        return ShortArrayList.newList((ShortIterable)this);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet((ShortIterable)this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag((ShortIterable)this);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    private class ReverseShortIterator
    implements ShortIterator {
        private int currentIndex;

        private ReverseShortIterator() {
            this.currentIndex = ReverseShortIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short next = ReverseShortIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

