/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MessageWaiter;
import com.google.cloud.pubsub.v1.SequentialExecutorService;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.GrpcPublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import com.google.pubsub.v1.TopicNames;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

public class Publisher {
    private static final Logger logger = Logger.getLogger(Publisher.class.getName());
    private final String topicName;
    private final BatchingSettings batchingSettings;
    private final boolean enableMessageOrdering;
    private final Lock messagesBatchLock;
    private final Map<String, MessagesBatch> messagesBatches;
    private final AtomicBoolean activeAlarm;
    private final PublisherStub publisherStub;
    private final ScheduledExecutorService executor;
    private final SequentialExecutorService.CallbackExecutor sequentialExecutor;
    private final AtomicBoolean shutdown;
    private final BackgroundResource backgroundResources;
    private final MessageWaiter messagesWaiter;
    private ScheduledFuture<?> currentAlarmFuture;
    private final ApiFunction<PubsubMessage, PubsubMessage> messageTransform;

    public static long getApiMaxRequestElementCount() {
        return 1000L;
    }

    public static long getApiMaxRequestBytes() {
        return 10000000L;
    }

    private Publisher(Builder builder) throws IOException {
        RetrySettings.Builder retrySettingsBuilder;
        this.topicName = builder.topicName;
        this.batchingSettings = builder.batchingSettings;
        this.enableMessageOrdering = builder.enableMessageOrdering;
        this.messageTransform = builder.messageTransform;
        this.messagesBatches = new HashMap<String, MessagesBatch>();
        this.messagesBatchLock = new ReentrantLock();
        this.activeAlarm = new AtomicBoolean(false);
        this.executor = builder.executorProvider.getExecutor();
        this.sequentialExecutor = new SequentialExecutorService.CallbackExecutor(this.executor);
        ArrayList<Object> backgroundResourceList = new ArrayList<Object>();
        if (builder.executorProvider.shouldAutoClose()) {
            backgroundResourceList.add(new ExecutorAsBackgroundResource((ExecutorService)this.executor));
        }
        if ((retrySettingsBuilder = builder.retrySettings.toBuilder()).getMaxAttempts() == 0) {
            retrySettingsBuilder.setMaxAttempts(Integer.MAX_VALUE);
        }
        if (this.enableMessageOrdering) {
            retrySettingsBuilder.setMaxAttempts(Integer.MAX_VALUE).setTotalTimeout(Duration.ofNanos((long)Long.MAX_VALUE));
        }
        PublisherStubSettings.Builder stubSettings = (PublisherStubSettings.Builder)((PublisherStubSettings.Builder)((PublisherStubSettings.Builder)PublisherStubSettings.newBuilder().setCredentialsProvider(builder.credentialsProvider)).setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)this.executor))).setTransportChannelProvider(builder.channelProvider);
        stubSettings.publishSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.CANCELLED, StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNKNOWN, StatusCode.Code.UNAVAILABLE}).setRetrySettings(retrySettingsBuilder.build()).setBatchingSettings(BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(false)).build());
        this.publisherStub = GrpcPublisherStub.create(stubSettings.build());
        backgroundResourceList.add(this.publisherStub);
        this.backgroundResources = new BackgroundResourceAggregation(backgroundResourceList);
        this.shutdown = new AtomicBoolean(false);
        this.messagesWaiter = new MessageWaiter();
    }

    public TopicName getTopicName() {
        return TopicNames.parse((String)this.topicName);
    }

    public String getTopicNameString() {
        return this.topicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<String> publish(PubsubMessage message) {
        List batchesToSend;
        Preconditions.checkState((!this.shutdown.get() ? 1 : 0) != 0, (Object)"Cannot publish on a shut-down publisher.");
        String orderingKey = message.getOrderingKey();
        Preconditions.checkState((orderingKey.isEmpty() || this.enableMessageOrdering ? 1 : 0) != 0, (Object)"Cannot publish a message with an ordering key when message ordering is not enabled.");
        OutstandingPublish outstandingPublish = new OutstandingPublish((PubsubMessage)this.messageTransform.apply((Object)message));
        this.messagesBatchLock.lock();
        try {
            MessagesBatch messagesBatch = this.messagesBatches.get(orderingKey);
            if (messagesBatch == null) {
                messagesBatch = new MessagesBatch(this.batchingSettings, orderingKey);
                this.messagesBatches.put(orderingKey, messagesBatch);
            }
            if (!(batchesToSend = messagesBatch.add(outstandingPublish)).isEmpty() && messagesBatch.isEmpty()) {
                this.messagesBatches.remove(orderingKey);
            }
            this.setupAlarm();
            if (!batchesToSend.isEmpty() && !orderingKey.isEmpty()) {
                for (OutstandingBatch batch : batchesToSend) {
                    logger.log(Level.FINER, "Scheduling a batch for immediate sending.");
                    this.publishOutstandingBatch(batch);
                }
            }
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        this.messagesWaiter.incrementPendingMessages(1);
        if (!batchesToSend.isEmpty() && orderingKey.isEmpty()) {
            for (OutstandingBatch batch : batchesToSend) {
                logger.log(Level.FINER, "Scheduling a batch for immediate sending.");
                this.publishOutstandingBatch(batch);
            }
        }
        return outstandingPublish.publishResult;
    }

    @BetaApi(value="Ordering is not yet fully supported and requires special project enablements.")
    public void resumePublish(String key) {
        Preconditions.checkState((!this.shutdown.get() ? 1 : 0) != 0, (Object)"Cannot publish on a shut-down publisher.");
        this.sequentialExecutor.resumePublish(key);
    }

    private void setupAlarm() {
        if (!this.messagesBatches.isEmpty()) {
            if (!this.activeAlarm.getAndSet(true)) {
                long delayThresholdMs = this.getBatchingSettings().getDelayThreshold().toMillis();
                logger.log(Level.FINER, "Setting up alarm for the next {0} ms.", delayThresholdMs);
                this.currentAlarmFuture = this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        logger.log(Level.FINER, "Sending messages based on schedule.");
                        Publisher.this.activeAlarm.getAndSet(false);
                        Publisher.this.publishAllWithoutInflight();
                    }
                }, delayThresholdMs, TimeUnit.MILLISECONDS);
            }
        } else if (this.currentAlarmFuture != null) {
            logger.log(Level.FINER, "Cancelling alarm, no more messages");
            if (this.activeAlarm.getAndSet(false)) {
                this.currentAlarmFuture.cancel(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAllOutstanding() {
        OutstandingBatch unorderedOutstandingBatch = null;
        this.messagesBatchLock.lock();
        try {
            for (MessagesBatch batch : this.messagesBatches.values()) {
                if (batch.isEmpty()) continue;
                if (!batch.orderingKey.isEmpty()) {
                    this.publishOutstandingBatch(batch.popOutstandingBatch());
                    continue;
                }
                unorderedOutstandingBatch = batch.popOutstandingBatch();
            }
            this.messagesBatches.clear();
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        if (unorderedOutstandingBatch != null) {
            this.publishOutstandingBatch(unorderedOutstandingBatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishAllWithoutInflight() {
        OutstandingBatch unorderedOutstandingBatch = null;
        this.messagesBatchLock.lock();
        try {
            Iterator<Map.Entry<String, MessagesBatch>> it = this.messagesBatches.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, MessagesBatch> entry = it.next();
                MessagesBatch batch = entry.getValue();
                String key = entry.getKey();
                if (batch.isEmpty()) {
                    it.remove();
                    continue;
                }
                if (key.isEmpty()) {
                    unorderedOutstandingBatch = batch.popOutstandingBatch();
                    it.remove();
                    continue;
                }
                if (this.sequentialExecutor.hasTasksInflight(key)) continue;
                this.publishOutstandingBatch(batch.popOutstandingBatch());
                it.remove();
            }
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        if (unorderedOutstandingBatch != null) {
            this.publishOutstandingBatch(unorderedOutstandingBatch);
        }
    }

    private ApiFuture<PublishResponse> publishCall(OutstandingBatch outstandingBatch) {
        return this.publisherStub.publishCallable().futureCall((Object)PublishRequest.newBuilder().setTopic(this.topicName).addAllMessages((Iterable)outstandingBatch.getMessages()).build());
    }

    private void publishOutstandingBatch(final OutstandingBatch outstandingBatch) {
        ApiFutureCallback<PublishResponse> futureCallback = new ApiFutureCallback<PublishResponse>(){

            public void onSuccess(PublishResponse result) {
                try {
                    if (result == null || result.getMessageIdsCount() != outstandingBatch.size()) {
                        outstandingBatch.onFailure(new IllegalStateException(String.format("The publish result count %s does not match the expected %s results. Please contact Cloud Pub/Sub support if this frequently occurs", result.getMessageIdsCount(), outstandingBatch.size())));
                    } else {
                        outstandingBatch.onSuccess((Iterable)result.getMessageIdsList());
                    }
                }
                finally {
                    Publisher.this.messagesWaiter.incrementPendingMessages(-outstandingBatch.size());
                }
            }

            public void onFailure(Throwable t) {
                try {
                    outstandingBatch.onFailure(t);
                }
                finally {
                    Publisher.this.messagesWaiter.incrementPendingMessages(-outstandingBatch.size());
                }
            }
        };
        ApiFuture<PublishResponse> future = outstandingBatch.orderingKey == null || outstandingBatch.orderingKey.isEmpty() ? this.publishCall(outstandingBatch) : this.sequentialExecutor.submit(outstandingBatch.orderingKey, new Callable<ApiFuture<PublishResponse>>(){

            @Override
            public ApiFuture<PublishResponse> call() {
                return Publisher.this.publishCall(outstandingBatch);
            }
        });
        ApiFutures.addCallback(future, (ApiFutureCallback)futureCallback, (Executor)MoreExecutors.directExecutor());
    }

    public BatchingSettings getBatchingSettings() {
        return this.batchingSettings;
    }

    public void shutdown() {
        Preconditions.checkState((!this.shutdown.getAndSet(true) ? 1 : 0) != 0, (Object)"Cannot shut down a publisher already shut-down.");
        if (this.currentAlarmFuture != null && this.activeAlarm.getAndSet(false)) {
            this.currentAlarmFuture.cancel(false);
        }
        this.publishAllOutstanding();
        this.backgroundResources.shutdown();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }

    public static Builder newBuilder(TopicName topicName) {
        return Publisher.newBuilder(topicName.toString());
    }

    public static Builder newBuilder(String topicName) {
        return new Builder(topicName);
    }

    private static class MessagesBatch {
        private List<OutstandingPublish> messages;
        private int batchedBytes;
        private String orderingKey;
        private final BatchingSettings batchingSettings;

        private MessagesBatch(BatchingSettings batchingSettings, String orderingKey) {
            this.batchingSettings = batchingSettings;
            this.orderingKey = orderingKey;
            this.reset();
        }

        private OutstandingBatch popOutstandingBatch() {
            OutstandingBatch batch = new OutstandingBatch(this.messages, this.batchedBytes, this.orderingKey);
            this.reset();
            return batch;
        }

        private void reset() {
            this.messages = new LinkedList<OutstandingPublish>();
            this.batchedBytes = 0;
        }

        private boolean isEmpty() {
            return this.messages.isEmpty();
        }

        private int getBatchedBytes() {
            return this.batchedBytes;
        }

        private int getMessagesCount() {
            return this.messages.size();
        }

        private boolean hasBatchingBytes() {
            return this.getMaxBatchBytes() > 0L;
        }

        private long getMaxBatchBytes() {
            return this.batchingSettings.getRequestByteThreshold();
        }

        private List<OutstandingBatch> add(OutstandingPublish outstandingPublish) {
            ArrayList<OutstandingBatch> batchesToSend = new ArrayList<OutstandingBatch>();
            if (!this.isEmpty() && this.hasBatchingBytes() && (long)(this.getBatchedBytes() + outstandingPublish.messageSize) >= this.getMaxBatchBytes()) {
                batchesToSend.add(this.popOutstandingBatch());
            }
            this.messages.add(outstandingPublish);
            this.batchedBytes += outstandingPublish.messageSize;
            if (this.hasBatchingBytes() && (long)outstandingPublish.messageSize >= this.getMaxBatchBytes() || (long)this.getMessagesCount() == this.batchingSettings.getElementCountThreshold()) {
                batchesToSend.add(this.popOutstandingBatch());
            }
            return batchesToSend;
        }
    }

    public static final class Builder {
        static final Duration MIN_TOTAL_TIMEOUT = Duration.ofSeconds((long)10L);
        static final Duration MIN_RPC_TIMEOUT = Duration.ofMillis((long)10L);
        static final long DEFAULT_ELEMENT_COUNT_THRESHOLD = 100L;
        static final long DEFAULT_REQUEST_BYTES_THRESHOLD = 1000L;
        static final Duration DEFAULT_DELAY_THRESHOLD = Duration.ofMillis((long)1L);
        private static final Duration DEFAULT_RPC_TIMEOUT = Duration.ofSeconds((long)10L);
        private static final Duration DEFAULT_TOTAL_TIMEOUT = MIN_TOTAL_TIMEOUT;
        static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setDelayThreshold(DEFAULT_DELAY_THRESHOLD).setRequestByteThreshold(Long.valueOf(1000L)).setElementCountThreshold(Long.valueOf(100L)).build();
        static final RetrySettings DEFAULT_RETRY_SETTINGS = RetrySettings.newBuilder().setTotalTimeout(DEFAULT_TOTAL_TIMEOUT).setInitialRetryDelay(Duration.ofMillis((long)5L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)Long.MAX_VALUE)).setInitialRpcTimeout(DEFAULT_RPC_TIMEOUT).setRpcTimeoutMultiplier(2.0).setMaxRpcTimeout(DEFAULT_RPC_TIMEOUT).build();
        static final boolean DEFAULT_ENABLE_MESSAGE_ORDERING = false;
        private static final int THREADS_PER_CPU = 5;
        static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5 * Runtime.getRuntime().availableProcessors()).build();
        String topicName;
        BatchingSettings batchingSettings = DEFAULT_BATCHING_SETTINGS;
        RetrySettings retrySettings = DEFAULT_RETRY_SETTINGS;
        private boolean enableMessageOrdering = false;
        private TransportChannelProvider channelProvider = TopicAdminSettings.defaultGrpcTransportProviderBuilder().setChannelsPerCpu(1.0).build();
        private HeaderProvider headerProvider = new NoHeaderProvider();
        private HeaderProvider internalHeaderProvider = TopicAdminSettings.defaultApiClientHeaderProviderBuilder().build();
        ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        private CredentialsProvider credentialsProvider = TopicAdminSettings.defaultCredentialsProviderBuilder().build();
        private ApiFunction<PubsubMessage, PubsubMessage> messageTransform = new ApiFunction<PubsubMessage, PubsubMessage>(){

            public PubsubMessage apply(PubsubMessage input) {
                return input;
            }
        };

        private Builder(String topic) {
            this.topicName = (String)Preconditions.checkNotNull((Object)topic);
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
            return this;
        }

        @BetaApi
        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = (HeaderProvider)Preconditions.checkNotNull((Object)headerProvider);
            return this;
        }

        Builder setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            this.internalHeaderProvider = (HeaderProvider)Preconditions.checkNotNull((Object)internalHeaderProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setBatchingSettings(BatchingSettings batchingSettings) {
            Preconditions.checkNotNull((Object)batchingSettings);
            Preconditions.checkNotNull((Object)batchingSettings.getElementCountThreshold());
            Preconditions.checkArgument((batchingSettings.getElementCountThreshold() > 0L ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)batchingSettings.getRequestByteThreshold());
            Preconditions.checkArgument((batchingSettings.getRequestByteThreshold() > 0L ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)batchingSettings.getDelayThreshold());
            Preconditions.checkArgument((batchingSettings.getDelayThreshold().toMillis() > 0L ? 1 : 0) != 0);
            this.batchingSettings = batchingSettings;
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            Preconditions.checkArgument((retrySettings.getTotalTimeout().compareTo(MIN_TOTAL_TIMEOUT) >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((retrySettings.getInitialRpcTimeout().compareTo(MIN_RPC_TIMEOUT) >= 0 ? 1 : 0) != 0);
            this.retrySettings = retrySettings;
            return this;
        }

        @BetaApi(value="Ordering is not yet fully supported and requires special project enablements.")
        public Builder setEnableMessageOrdering(boolean enableMessageOrdering) {
            this.enableMessageOrdering = enableMessageOrdering;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        @BetaApi
        public Builder setTransform(ApiFunction<PubsubMessage, PubsubMessage> messageTransform) {
            this.messageTransform = (ApiFunction)Preconditions.checkNotNull(messageTransform, (Object)"The messageTransform cannnot be null.");
            return this;
        }

        public Publisher build() throws IOException {
            return new Publisher(this);
        }
    }

    private static final class OutstandingPublish {
        final SettableApiFuture<String> publishResult = SettableApiFuture.create();
        final PubsubMessage message;
        final int messageSize;

        OutstandingPublish(PubsubMessage message) {
            this.message = message;
            this.messageSize = message.getSerializedSize();
        }
    }

    private static final class OutstandingBatch {
        final List<OutstandingPublish> outstandingPublishes;
        final long creationTime;
        int attempt;
        int batchSizeBytes;
        final String orderingKey;

        OutstandingBatch(List<OutstandingPublish> outstandingPublishes, int batchSizeBytes, String orderingKey) {
            this.outstandingPublishes = outstandingPublishes;
            this.attempt = 1;
            this.creationTime = System.currentTimeMillis();
            this.batchSizeBytes = batchSizeBytes;
            this.orderingKey = orderingKey;
        }

        int size() {
            return this.outstandingPublishes.size();
        }

        private List<PubsubMessage> getMessages() {
            ArrayList<PubsubMessage> results = new ArrayList<PubsubMessage>(this.outstandingPublishes.size());
            for (OutstandingPublish outstandingPublish : this.outstandingPublishes) {
                results.add(outstandingPublish.message);
            }
            return results;
        }

        private void onFailure(Throwable t) {
            for (OutstandingPublish outstandingPublish : this.outstandingPublishes) {
                outstandingPublish.publishResult.setException(t);
            }
        }

        private void onSuccess(Iterable<String> results) {
            Iterator<OutstandingPublish> messagesResultsIt = this.outstandingPublishes.iterator();
            for (String messageId : results) {
                messagesResultsIt.next().publishResult.set((Object)messageId);
            }
        }
    }
}

