/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Function
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String function;
    private final List<String> parameters = new ArrayList<String>();

    public Function() {
    }

    public Function(String functionBody) {
        this.function = functionBody;
    }

    public String getFunction() {
        String result = this.getSignature();
        result = result + "{";
        result = result + this.getBody();
        result = result + "}";
        return result;
    }

    public String getBody() {
        String result = "";
        if (this.function != null) {
            result = result + this.function;
        }
        return result;
    }

    public Function setFunction(String functionBody) {
        this.function = functionBody;
        return this;
    }

    protected void addParameter(String parameter) {
        this.parameters.add(parameter);
    }

    private String getSignature() {
        if (this.parameters.isEmpty()) {
            return "function()";
        }
        String signature = "function(";
        boolean first = true;
        for (String param : this.parameters) {
            if (!first) {
                signature = signature + ",";
            }
            signature = signature + param;
            first = false;
        }
        signature = signature + ")";
        return signature;
    }
}

