/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LanguageOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String decimalPoint;
    private String downloadPNG;
    private String downloadJPEG;
    private String downloadPDF;
    private String downloadSVG;
    private String exportButtonTitle;
    private String loading;
    private List<String> months;
    private List<String> shortMonths;
    private String printButtonTitle;
    private String resetZoom;
    private String resetZoomTitle;
    private String thousandsSep;
    private List<String> weekdays;

    public static LanguageOptions forLocale(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(LanguageOptions.class.getName(), locale);
            LanguageOptions options = new LanguageOptions();
            options.setDecimalPoint(bundle.getString("decimalPoint"));
            options.setDownloadPNG(bundle.getString("downloadPNG"));
            options.setDownloadJPEG(bundle.getString("downloadJPEG"));
            options.setDownloadPDF(bundle.getString("downloadPDF"));
            options.setDownloadSVG(bundle.getString("downloadSVG"));
            options.setExportButtonTitle(bundle.getString("exportButtonTitle"));
            options.setLoading(bundle.getString("loading"));
            options.setMonths(Arrays.asList(bundle.getString("months").split(",")));
            options.setShortMonths(Arrays.asList(bundle.getString("shortMonths").split(",")));
            options.setPrintButtonTitle(bundle.getString("printButtonTitle"));
            options.setResetZoom(bundle.getString("resetZoom"));
            options.setResetZoomTitle(bundle.getString("resetZoomTitle"));
            options.setThousandsSep(bundle.getString("thousandsSep"));
            options.setWeekdays(Arrays.asList(bundle.getString("weekdays").split(",")));
            return options;
        }
        catch (MissingResourceException e) {
            return new LanguageOptions();
        }
    }

    public String getDecimalPoint() {
        return this.decimalPoint;
    }

    public String getDownloadJPEG() {
        return this.downloadJPEG;
    }

    public String getDownloadPDF() {
        return this.downloadPDF;
    }

    public String getDownloadPNG() {
        return this.downloadPNG;
    }

    public String getDownloadSVG() {
        return this.downloadSVG;
    }

    public String getExportButtonTitle() {
        return this.exportButtonTitle;
    }

    public String getLoading() {
        return this.loading;
    }

    public List<String> getMonths() {
        return this.months;
    }

    public String getPrintButtonTitle() {
        return this.printButtonTitle;
    }

    public String getResetZoom() {
        return this.resetZoom;
    }

    public String getResetZoomTitle() {
        return this.resetZoomTitle;
    }

    public List<String> getShortMonths() {
        return this.shortMonths;
    }

    public String getThousandsSep() {
        return this.thousandsSep;
    }

    public List<String> getWeekdays() {
        return this.weekdays;
    }

    public LanguageOptions setDecimalPoint(String decimalPoint) {
        this.decimalPoint = decimalPoint;
        return this;
    }

    public LanguageOptions setDownloadJPEG(String downloadJPEG) {
        this.downloadJPEG = downloadJPEG;
        return this;
    }

    public LanguageOptions setDownloadPDF(String downloadPDF) {
        this.downloadPDF = downloadPDF;
        return this;
    }

    public LanguageOptions setDownloadPNG(String downloadPNG) {
        this.downloadPNG = downloadPNG;
        return this;
    }

    public LanguageOptions setDownloadSVG(String downloadSVG) {
        this.downloadSVG = downloadSVG;
        return this;
    }

    public LanguageOptions setExportButtonTitle(String exportButtonTitle) {
        this.exportButtonTitle = exportButtonTitle;
        return this;
    }

    public LanguageOptions setLoading(String loading) {
        this.loading = loading;
        return this;
    }

    public LanguageOptions setMonths(List<String> months) {
        this.months = months;
        return this;
    }

    public LanguageOptions setPrintButtonTitle(String printButtonTitle) {
        this.printButtonTitle = printButtonTitle;
        return this;
    }

    public LanguageOptions setResetZoom(String resetZoom) {
        this.resetZoom = resetZoom;
        return this;
    }

    public LanguageOptions setResetZoomTitle(String resetZoomTitle) {
        this.resetZoomTitle = resetZoomTitle;
        return this;
    }

    public LanguageOptions setShortMonths(List<String> shortMonths) {
        this.shortMonths = shortMonths;
        return this;
    }

    public LanguageOptions setThousandsSep(String thousandsSep) {
        this.thousandsSep = thousandsSep;
        return this;
    }

    public LanguageOptions setWeekdays(List<String> weekdays) {
        this.weekdays = weekdays;
        return this;
    }
}

