/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjdoc;

import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.string.StringHelper;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.jjdoc.IDocGenerator;
import com.helger.pgcc.jjdoc.JJDoc;
import com.helger.pgcc.jjdoc.JJDocGlobals;
import com.helger.pgcc.jjdoc.JJDocOptions;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.CodeProductionCpp;
import com.helger.pgcc.parser.CodeProductionJava;
import com.helger.pgcc.parser.ExpNonTerminal;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.NormalProduction;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.TokenProduction;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class TextGenerator
implements IDocGenerator {
    protected Writer m_aPW;

    @Override
    public void text(String string) throws IOException {
        this.print(string);
    }

    @Override
    public void print(String string) throws IOException {
        this.m_aPW.write(string);
    }

    @Override
    public void documentStart() throws IOException {
        this.m_aPW = TextGenerator.createPrintWriter();
        this.m_aPW.write("\nDOCUMENT START\n");
    }

    @Override
    public void documentEnd() throws IOException {
        this.m_aPW.write("\nDOCUMENT END\n");
        this.m_aPW.close();
    }

    @Override
    public void specialTokens(String string) throws IOException {
        this.m_aPW.write(string);
    }

    @Override
    public void nonterminalsStart() throws IOException {
        this.text("NON-TERMINALS\n");
    }

    @Override
    public void nonterminalsEnd() throws IOException {
    }

    @Override
    public void tokensStart() throws IOException {
        this.text("TOKENS\n");
    }

    @Override
    public void handleTokenProduction(TokenProduction tokenProduction) throws IOException {
        String string = JJDoc.getStandardTokenProductionText(tokenProduction);
        this.text(string);
    }

    @Override
    public void tokensEnd() throws IOException {
    }

    @Override
    public void javacode(CodeProductionJava codeProductionJava) throws IOException {
        this.productionStart(codeProductionJava);
        this.text("java code");
        this.productionEnd(codeProductionJava);
    }

    @Override
    public void cppcode(CodeProductionCpp codeProductionCpp) throws IOException {
        this.productionStart(codeProductionCpp);
        this.text("c++ code");
        this.productionEnd(codeProductionCpp);
    }

    @Override
    public void productionStart(NormalProduction normalProduction) throws IOException {
        this.m_aPW.write("\t" + normalProduction.getLhs() + "\t:=\t");
    }

    @Override
    public void productionEnd(NormalProduction normalProduction) throws IOException {
        this.m_aPW.write("\n");
    }

    @Override
    public void expansionStart(Expansion expansion, boolean bl) throws IOException {
        if (!bl) {
            this.m_aPW.write("\n\t\t|\t");
        }
    }

    @Override
    public void expansionEnd(Expansion expansion, boolean bl) throws IOException {
    }

    @Override
    public void nonTerminalStart(ExpNonTerminal expNonTerminal) throws IOException {
    }

    @Override
    public void nonTerminalEnd(ExpNonTerminal expNonTerminal) throws IOException {
    }

    @Override
    public void reStart(AbstractExpRegularExpression abstractExpRegularExpression) throws IOException {
    }

    @Override
    public void reEnd(AbstractExpRegularExpression abstractExpRegularExpression) throws IOException {
    }

    @Nonnull
    protected static Writer createPrintWriter() {
        String string = ".html";
        if (JJDocOptions.isText()) {
            string = ".txt";
        } else if (JJDocOptions.isXText()) {
            string = ".xtext";
        }
        return TextGenerator.createPrintWriter(string);
    }

    @Nonnull
    protected static Writer createPrintWriter(@Nonnull String string) {
        if (StringHelper.hasNoText((String)JJDocOptions.getOutputFile())) {
            String string2;
            if (JJDocGlobals.s_input_file.equals("standard input")) {
                return PGPrinter.getOutWriter();
            }
            int n = JJDocGlobals.s_input_file.lastIndexOf(46);
            JJDocGlobals.s_output_file = n == -1 ? JJDocGlobals.s_input_file + string : ((string2 = JJDocGlobals.s_input_file.substring(n)).equals(string) ? JJDocGlobals.s_input_file + string : JJDocGlobals.s_input_file.substring(0, n) + string);
        } else {
            JJDocGlobals.s_output_file = JJDocOptions.getOutputFile();
        }
        NonBlockingBufferedWriter nonBlockingBufferedWriter = FileHelper.getBufferedWriter((File)new File(JJDocGlobals.s_output_file), (Charset)Options.getOutputEncoding());
        if (nonBlockingBufferedWriter != null) {
            return new PrintWriter((Writer)nonBlockingBufferedWriter);
        }
        PGPrinter.error("JJDoc: can't open output stream on file " + JJDocGlobals.s_output_file + ".  Using standard output.");
        return PGPrinter.getOutWriter();
    }
}

