/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree;

import com.helger.commons.state.ESuccess;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.jjtree.ASTGrammar;
import com.helger.pgcc.jjtree.ASTNodeDescriptor;
import com.helger.pgcc.jjtree.JJTreeGlobals;
import com.helger.pgcc.jjtree.JJTreeIO;
import com.helger.pgcc.jjtree.JJTreeOptions;
import com.helger.pgcc.jjtree.JJTreeParser;
import com.helger.pgcc.jjtree.ParseException;
import com.helger.pgcc.jjtree.StreamProvider;
import com.helger.pgcc.jjtree.output.JJTreeStateCpp;
import com.helger.pgcc.jjtree.output.JJTreeStateJava;
import com.helger.pgcc.jjtree.output.NodeFilesCpp;
import com.helger.pgcc.jjtree.output.NodeFilesJava;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.Main;
import com.helger.pgcc.parser.Options;
import java.io.IOException;
import javax.annotation.Nonnull;

public class JJTree {
    private JJTreeIO io;

    private void help_message() {
        PGPrinter.info("Usage:");
        PGPrinter.info("    jjtree option-settings inputfile");
        PGPrinter.info("");
        PGPrinter.info("\"option-settings\" is a sequence of settings separated by spaces.");
        PGPrinter.info("Each option setting must be of one of the following forms:");
        PGPrinter.info("");
        PGPrinter.info("    -optionname=value (e.g., -STATIC=false)");
        PGPrinter.info("    -optionname:value (e.g., -STATIC:false)");
        PGPrinter.info("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        PGPrinter.info("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        PGPrinter.info("");
        PGPrinter.info("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        PGPrinter.info("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        PGPrinter.info("option, and must be either an integer or a string value.");
        PGPrinter.info("");
        PGPrinter.info("The boolean valued options are:");
        PGPrinter.info("");
        PGPrinter.info("    MULTI                    (default false)");
        PGPrinter.info("    NODE_DEFAULT_VOID        (default false)");
        PGPrinter.info("    NODE_SCOPE_HOOK          (default false)");
        PGPrinter.info("    NODE_USES_PARSER         (default false)");
        PGPrinter.info("    BUILD_NODE_FILES         (default true)");
        PGPrinter.info("    TRACK_TOKENS             (default false)");
        PGPrinter.info("    VISITOR                  (default false)");
        PGPrinter.info("");
        PGPrinter.info("The string valued options are:");
        PGPrinter.info("");
        PGPrinter.info("    JDK_VERSION              (default \"1.5\")");
        PGPrinter.info("    NODE_CLASS               (default \"\")");
        PGPrinter.info("    NODE_PREFIX              (default \"AST\")");
        PGPrinter.info("    NODE_PACKAGE             (default \"\")");
        PGPrinter.info("    NODE_EXTENDS             (default \"\")");
        PGPrinter.info("    NODE_FACTORY             (default \"\")");
        PGPrinter.info("    OUTPUT_FILE              (default remove input file suffix, add .jj)");
        PGPrinter.info("    OUTPUT_DIRECTORY         (default \"\")");
        PGPrinter.info("    JJTREE_OUTPUT_DIRECTORY  (default value of OUTPUT_DIRECTORY option)");
        PGPrinter.info("    VISITOR_DATA_TYPE        (default \"\")");
        PGPrinter.info("    VISITOR_RETURN_TYPE      (default \"Object\")");
        PGPrinter.info("    VISITOR_EXCEPTION        (default \"\")");
        PGPrinter.info("");
        PGPrinter.info("JJTree also accepts JavaCC options, which it inserts into the generated file.");
        PGPrinter.info("");
        PGPrinter.info("EXAMPLES:");
        PGPrinter.info("    jjtree -STATIC=false mygrammar.jjt");
        PGPrinter.info("");
        PGPrinter.info("ABOUT JJTree:");
        PGPrinter.info("    JJTree is a preprocessor for JavaCC that inserts actions into a");
        PGPrinter.info("    JavaCC grammar to build parse trees for the input.");
        PGPrinter.info("");
        PGPrinter.info("    For more information, see the online JJTree documentation at ");
        PGPrinter.info("    https://javacc.dev.java.net/doc/JJTree.html ");
        PGPrinter.info("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public ESuccess main(String[] stringArray) {
        ASTNodeDescriptor.reInit();
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Tree Builder", "");
        this.io = new JJTreeIO();
        try {
            this.initializeOptions();
            if (stringArray.length == 0) {
                PGPrinter.info("");
                this.help_message();
                ESuccess eSuccess = ESuccess.FAILURE;
                return eSuccess;
            }
            PGPrinter.info("(type \"jjtree\" with no arguments for help)");
            String string = stringArray[stringArray.length - 1];
            if (Options.isOption(string)) {
                PGPrinter.info("Last argument \"" + string + "\" is not a filename");
                ESuccess eSuccess = ESuccess.FAILURE;
                return eSuccess;
            }
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (!Options.isOption(stringArray[i])) {
                    PGPrinter.info("Argument \"" + stringArray[i] + "\" must be an option setting.");
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                Options.setCmdLineOption(stringArray[i]);
            }
            JJTreeOptions.validate();
            try {
                this.io.setInput(string);
            }
            catch (IOException iOException) {
                PGPrinter.info("Error setting input: " + iOException.getMessage());
                ESuccess eSuccess = ESuccess.FAILURE;
                this.io.closeAll();
                return eSuccess;
            }
            PGPrinter.info("Reading from file " + this.io.getInputFilename() + " . . .");
            JJTreeGlobals.toolList.clear();
            JJTreeGlobals.toolList.addAll(JavaCCGlobals.getToolNames(string));
            JJTreeGlobals.toolList.add("JJTree");
            try {
                JJTreeParser jJTreeParser = new JJTreeParser(new StreamProvider(this.io.getIn()));
                jJTreeParser.javacc_input();
                ASTGrammar aSTGrammar = (ASTGrammar)jJTreeParser.jjtree.rootNode();
                if (Boolean.getBoolean("jjtree-dump")) {
                    aSTGrammar.dump(" ");
                }
                try {
                    this.io.setOutput();
                }
                catch (IOException iOException) {
                    PGPrinter.info("Error setting output: " + iOException.getMessage());
                    ESuccess eSuccess = ESuccess.FAILURE;
                    this.io.closeAll();
                    return eSuccess;
                }
                aSTGrammar.generate(this.io);
                this.io.getOut().close();
            }
            catch (ParseException parseException) {
                block26: {
                    PGPrinter.error("Error parsing input: " + parseException.toString());
                    break block26;
                    catch (Exception exception) {
                        PGPrinter.error("Error parsing input", exception);
                    }
                }
                ESuccess eSuccess = ESuccess.FAILURE;
                return eSuccess;
            }
            switch (Options.getOutputLanguage()) {
                case JAVA: {
                    NodeFilesJava.generateTreeConstants_java();
                    NodeFilesJava.generateVisitor_java();
                    NodeFilesJava.generateDefaultVisitor_java();
                    JJTreeStateJava.generateTreeState_java();
                    break;
                }
                case CPP: {
                    NodeFilesCpp.generateTreeConstants();
                    NodeFilesCpp.generateVisitors();
                    JJTreeStateCpp.generateTreeState();
                    break;
                }
                default: {
                    PGPrinter.info("Unsupported JJTree output language : " + (Object)((Object)Options.getOutputLanguage()));
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
            }
            PGPrinter.info("Annotated grammar generated successfully in " + this.io.getOutputFilename());
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            this.io.closeAll();
        }
    }

    private void initializeOptions() {
        JJTreeOptions.init();
        JJTreeGlobals.initialize();
    }
}

