/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.output.cpp;

import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.PGVersion;
import com.helger.pgcc.output.OutputFile;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.utils.OutputFileGenerator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;

public class FilesCpp {
    private FilesCpp() {
    }

    private static void genFile(String string, String string2, String string3, String[] stringArray) {
        File file = new File(Options.getOutputDirectory(), string2);
        try (OutputFile outputFile = new OutputFile(file, string3, stringArray);){
            if (!outputFile.needToWrite()) {
                return;
            }
            try (PrintWriter printWriter = outputFile.getPrintWriter();){
                OutputFileGenerator outputFileGenerator = new OutputFileGenerator("/templates/" + string + "/" + string2 + ".template", Options.getAllOptions());
                outputFileGenerator.generate(printWriter);
            }
        }
        catch (IOException iOException) {
            PGPrinter.error("Failed to create file: " + file, iOException);
            JavaCCErrors.semantic_error("Could not open file: " + file + " for writing.");
            throw new UncheckedIOException(iOException);
        }
    }

    public static void gen_CharStream() {
        String[] stringArray = new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("stream/cpp", "CharStream.h", PGVersion.MAJOR_DOT_MINOR, stringArray);
        FilesCpp.genFile("stream/cpp", "CharStream.cc", PGVersion.MAJOR_DOT_MINOR, stringArray);
    }

    public static void gen_ParseException() {
        String[] stringArray = new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("cpp", "ParseException.h", PGVersion.MAJOR_DOT_MINOR, stringArray);
        FilesCpp.genFile("cpp", "ParseException.cc", PGVersion.MAJOR_DOT_MINOR, stringArray);
    }

    public static void gen_TokenMgrError() {
        String[] stringArray = new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("cpp", "TokenMgrError.h", PGVersion.MAJOR_DOT_MINOR, stringArray);
        FilesCpp.genFile("cpp", "TokenMgrError.cc", PGVersion.MAJOR_DOT_MINOR, stringArray);
    }

    public static void gen_Token() {
        String[] stringArray = new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC", "TOKEN_INCLUDES", "TOKEN_EXTENDS"};
        FilesCpp.genFile("cpp", "Token.h", PGVersion.MAJOR_DOT_MINOR, stringArray);
        FilesCpp.genFile("cpp", "Token.cc", PGVersion.MAJOR_DOT_MINOR, stringArray);
    }

    public static void gen_TokenManager() {
        String[] stringArray = new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("cpp", "TokenManager.h", PGVersion.MAJOR_DOT_MINOR, stringArray);
    }

    public static void gen_JavaCCDefs() {
        String[] stringArray = new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC"};
        FilesCpp.genFile("cpp", "JavaCC.h", PGVersion.MAJOR_DOT_MINOR, stringArray);
    }

    public static void gen_ErrorHandler() {
        String[] stringArray = new String[]{"SUPPORT_CLASS_VISIBILITY_PUBLIC", "BUILD_PARSER", "BUILD_TOKEN_MANAGER"};
        FilesCpp.genFile("cpp", "ErrorHandler.h", PGVersion.MAJOR_DOT_MINOR, stringArray);
    }

    public static void reInit() {
    }
}

