/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingBufferedWriter;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.UnsupportedOutputLanguageException;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Token;
import com.helger.pgcc.utils.OutputFileGenerator;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public class CodeGenerator {
    private final StringBuilder m_aMainBuffer = new StringBuilder();
    private final StringBuilder m_aIncludeBuffer = new StringBuilder();
    private final StringBuilder m_aStaticsBuffer = new StringBuilder();
    private StringBuilder m_aOutputBuffer = this.m_aMainBuffer;
    private int m_nLine;
    private int m_nCol;

    @Nonnull
    protected final EOutputLanguage getOutputLanguage() {
        return Options.getOutputLanguage();
    }

    public final void switchToMainFile() {
        this.m_aOutputBuffer = this.m_aMainBuffer;
    }

    public final void switchToStaticsFile() {
        if (this.getOutputLanguage().hasStaticsFile()) {
            this.m_aOutputBuffer = this.m_aStaticsBuffer;
        }
    }

    public final void switchToIncludeFile() {
        if (this.getOutputLanguage().hasIncludeFile()) {
            this.m_aOutputBuffer = this.m_aIncludeBuffer;
        }
    }

    protected final int getCol() {
        return this.m_nCol;
    }

    protected final int getLine() {
        return this.m_nLine;
    }

    protected final void setColToStart() {
        this.m_nCol = 1;
    }

    protected final void setLineAndCol(int n, int n2) {
        this.m_nLine = n;
        this.m_nCol = n2;
    }

    public final void genStringLiteralArrayCPP(String string, String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            this.genCodeLine("static const JJChar " + string + "_arr_" + n + "[] = ");
            this.genStringLiteralInCPP(stringArray[n]);
            this.genCodeLine(";");
        }
        this.genCodeLine("static const JJString " + string + "[] = {");
        for (n = 0; n < stringArray.length; ++n) {
            this.genCodeLine(string + "_arr_" + n + ", ");
        }
        this.genCodeLine("};");
    }

    public final void genStringLiteralInCPP(String string) {
        this.m_aOutputBuffer.append("{");
        for (char c : string.toCharArray()) {
            this.m_aOutputBuffer.append("0x").append(Integer.toHexString(c)).append(", ");
        }
        this.m_aOutputBuffer.append("0}");
    }

    public final void genCode(char c) {
        this.m_aOutputBuffer.append(c);
    }

    public final void genCode(String string) {
        this.m_aOutputBuffer.append(string);
    }

    public final void genCodeNewLine() {
        this.genCode("\n");
    }

    public final void genCodeLine(String string) {
        this.genCode(string);
        this.genCodeNewLine();
    }

    public final void saveOutput(String string) {
        if (this.getOutputLanguage().hasIncludeFile()) {
            String string2 = string.replace(".cc", ".h");
            String string3 = new File(string2).getName();
            String string4 = string3.replace('.', '_').toUpperCase(Locale.US);
            this.m_aIncludeBuffer.insert(0, "#define " + string4 + "\n");
            this.m_aIncludeBuffer.insert(0, "#ifndef " + string4 + "\n");
            this.m_aMainBuffer.insert(0, this.m_aStaticsBuffer);
            if (Options.stringValue("NAMESPACE").length() > 0) {
                this.m_aMainBuffer.insert(0, "namespace " + Options.stringValue("NAMESPACE_OPEN") + "\n");
                this.m_aMainBuffer.append(Options.stringValue("NAMESPACE_CLOSE") + "\n");
                this.m_aIncludeBuffer.append(Options.stringValue("NAMESPACE_CLOSE") + "\n");
            }
            if (JavaCCGlobals.s_jjtreeGenerated) {
                this.m_aMainBuffer.insert(0, "#include \"SimpleNode.h\"\n");
            }
            if (Options.isTokenManagerUsesParser()) {
                this.m_aMainBuffer.insert(0, "#include \"" + JavaCCGlobals.s_cu_name + ".h\"\n");
            }
            this.m_aMainBuffer.insert(0, "#include \"TokenMgrError.h\"\n");
            this.m_aMainBuffer.insert(0, "#include \"" + string3 + "\"\n");
            this.m_aIncludeBuffer.append("#endif\n");
            this.saveOutput(string2, this.m_aIncludeBuffer);
        }
        this.m_aMainBuffer.insert(0, "/* " + new File(string).getName() + " */\n");
        this.saveOutput(string, this.m_aMainBuffer);
    }

    public final void saveOutput(String string, StringBuilder stringBuilder) {
        try (NonBlockingBufferedWriter nonBlockingBufferedWriter = FileHelper.getBufferedWriter((File)new File(string), (Charset)Options.getOutputEncoding());){
            nonBlockingBufferedWriter.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
            JavaCCErrors.fatal("Could not create output file: " + string);
        }
    }

    protected final void printTokenSetup(Token token) {
        Token token2 = token;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        this.m_nLine = token2.beginLine;
        this.m_nCol = token2.beginColumn;
    }

    protected final void printTokenList(List<Token> list) {
        Token token = null;
        Iterator<Token> iterator = list.iterator();
        while (iterator.hasNext()) {
            Token token2;
            token = token2 = iterator.next();
            this.printToken(token);
        }
        if (token != null) {
            this.printTrailingComments(token);
        }
    }

    protected final void printTokenOnly(Token token) {
        this.genCode(this.getStringForTokenOnly(token));
    }

    protected final String getStringForTokenOnly(Token token) {
        char c;
        String string = "";
        while (this.m_nLine < token.beginLine) {
            string = string + "\n";
            this.m_nCol = 1;
            ++this.m_nLine;
        }
        while (this.m_nCol < token.beginColumn) {
            string = string + " ";
            ++this.m_nCol;
        }
        string = token.kind == 101 || token.kind == 100 ? string + JavaCCGlobals.addUnicodeEscapes(token.image) : string + token.image;
        this.m_nLine = token.endLine;
        this.m_nCol = token.endColumn + 1;
        if (token.image.length() > 0 && ((c = token.image.charAt(token.image.length() - 1)) == '\n' || c == '\r')) {
            ++this.m_nLine;
            this.m_nCol = 1;
        }
        return string;
    }

    protected final void printToken(@Nonnull Token token) {
        this.genCode(this.getStringToPrint(token));
    }

    protected final String getStringToPrint(@Nonnull Token token) {
        String string = "";
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                string = string + this.getStringForTokenOnly(token2);
                token2 = token2.next;
            }
        }
        return string + this.getStringForTokenOnly(token);
    }

    protected final void printLeadingComments(Token token) {
        this.genCode(this.getLeadingComments(token));
    }

    protected final String getLeadingComments(Token token) {
        String string = "";
        if (token.specialToken == null) {
            return string;
        }
        Token token2 = token.specialToken;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        while (token2 != null) {
            string = string + this.getStringForTokenOnly(token2);
            token2 = token2.next;
        }
        if (this.m_nCol != 1 && this.m_nLine != token.beginLine) {
            string = string + "\n";
            ++this.m_nLine;
            this.m_nCol = 1;
        }
        return string;
    }

    protected final void printTrailingComments(Token token) {
        this.m_aOutputBuffer.append(this.getTrailingComments(token));
    }

    protected final String getTrailingComments(Token token) {
        if (token.next == null) {
            return "";
        }
        return this.getLeadingComments(token.next);
    }

    public final String getGeneratedCode() {
        return this.m_aOutputBuffer.toString() + "\n";
    }

    public final void genAnnotation(String string) {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                this.genCode("@" + string);
                break;
            }
            case CPP: {
                this.genCode("/*" + string + "*/");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
    }

    public final void genModifier(String string) {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                this.genCode(string);
                break;
            }
            case CPP: {
                String string2 = string.trim().toLowerCase(Locale.US);
                if (!string2.equals("public") && !string2.equals("protected") && !string2.equals("private")) break;
                this.genCode(string2 + ": ");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
    }

    public final void genClassStart(String string, String string2, String[] stringArray, String[] stringArray2) {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                if (string != null) {
                    this.genModifier(string);
                }
                this.genCode("class " + string2);
                if (stringArray.length == 1 && stringArray[0] != null) {
                    this.genCode(" extends " + stringArray[0]);
                }
                if (stringArray2.length != 0) {
                    this.genCode(" implements ");
                }
                this._genCommaSeperatedString(stringArray2);
                this.genCodeLine(" {");
                break;
            }
            case CPP: {
                this.genCode("class " + string2);
                if (stringArray.length > 0 || stringArray2.length > 0) {
                    this.genCode(" : ");
                }
                this._genCommaSeperatedString(stringArray);
                this._genCommaSeperatedString(stringArray2);
                this.genCodeLine(" {");
                this.genCodeLine("public:");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
    }

    private void _genCommaSeperatedString(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                this.genCode(", ");
            }
            this.genCode(stringArray[i]);
        }
    }

    public final void generateMethodDefHeader(String string, String string2, String string3) {
        this.generateMethodDefHeader(string, string2, string3, null);
    }

    public final void generateMethodDefHeader(String string, String string2, String string3, String string4) {
        EOutputLanguage eOutputLanguage = this.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                this.genCode(string + " " + string3);
                if (string4 != null) {
                    this.genCode(" throws " + string4);
                }
                this.genCodeNewLine();
                break;
            }
            case CPP: {
                String string5;
                this.m_aIncludeBuffer.append(string + " " + string3);
                this.m_aIncludeBuffer.append(";\n");
                String string6 = null;
                int n = string.lastIndexOf(58);
                if (n >= 0) {
                    string6 = string.substring(n + 1);
                }
                if (string6 != null && (n = string6.lastIndexOf("virtual")) >= 0) {
                    string6 = string6.substring(n + "virtual".length());
                }
                if ((n = (string5 = string).lastIndexOf("virtual")) >= 0) {
                    string5 = string5.substring(n + "virtual".length());
                }
                this.m_aMainBuffer.append("\n" + string5 + " " + this.getClassQualifier(string2) + string3);
                this.switchToMainFile();
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
    }

    protected final String getClassQualifier(String string) {
        return string == null ? "" : string + "::";
    }

    public static String getCharStreamName() {
        if (Options.isJavaUserCharStream()) {
            return "CharStream";
        }
        return Options.isJavaUnicodeEscape() ? "JavaCharStream" : "SimpleCharStream";
    }

    protected final void writeTemplate(String string, Map<String, Object> map) throws IOException {
        OutputFileGenerator outputFileGenerator = new OutputFileGenerator(string, map);
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();){
            outputFileGenerator.generate((Writer)nonBlockingStringWriter);
            this.genCode(nonBlockingStringWriter.getAsString());
        }
    }
}

