/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.PGPrinter;
import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.ExpChoice;
import com.helger.pgcc.parser.ExpLookahead;
import com.helger.pgcc.parser.ExpOneOrMore;
import com.helger.pgcc.parser.ExpRStringLiteral;
import com.helger.pgcc.parser.ExpSequence;
import com.helger.pgcc.parser.ExpZeroOrMore;
import com.helger.pgcc.parser.ExpZeroOrOne;
import com.helger.pgcc.parser.Expansion;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.JavaCCGlobals;
import com.helger.pgcc.parser.LookaheadWalk;
import com.helger.pgcc.parser.MatchInfo;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.Semanticize;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LookaheadCalc {
    private LookaheadCalc() {
    }

    @Nullable
    private static MatchInfo _overlap(List<MatchInfo> list, List<MatchInfo> list2) {
        for (int i = 0; i < list.size(); ++i) {
            MatchInfo matchInfo = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                MatchInfo matchInfo2 = list2.get(j);
                int n = matchInfo.m_firstFreeLoc;
                MatchInfo matchInfo3 = matchInfo;
                if (n > matchInfo2.m_firstFreeLoc) {
                    n = matchInfo2.m_firstFreeLoc;
                    matchInfo3 = matchInfo2;
                }
                if (n == 0) {
                    return null;
                }
                boolean bl = false;
                for (int k = 0; k < n; ++k) {
                    if (matchInfo.m_match[k] == matchInfo2.m_match[k]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return matchInfo3;
            }
        }
        return null;
    }

    private static boolean _isJavaCodeCheck(List<MatchInfo> list) {
        for (MatchInfo matchInfo : list) {
            if (matchInfo.m_firstFreeLoc != 0) continue;
            return true;
        }
        return false;
    }

    private static String _image(@Nonnull MatchInfo matchInfo) {
        String string = "";
        for (int i = 0; i < matchInfo.m_firstFreeLoc; ++i) {
            AbstractExpRegularExpression abstractExpRegularExpression;
            string = matchInfo.m_match[i] == 0 ? string + " <EOF>" : ((abstractExpRegularExpression = JavaCCGlobals.s_rexps_of_tokens.get(matchInfo.m_match[i])) instanceof ExpRStringLiteral ? string + " \"" + JavaCCGlobals.addEscapes(((ExpRStringLiteral)abstractExpRegularExpression).m_image) + "\"" : (StringHelper.hasText((String)abstractExpRegularExpression.m_label) ? string + " <" + abstractExpRegularExpression.m_label + ">" : string + " <token of kind " + i + ">"));
        }
        if (matchInfo.m_firstFreeLoc == 0) {
            return "";
        }
        return string.substring(1);
    }

    public static void choiceCalc(ExpChoice expChoice) {
        int n;
        int n2 = LookaheadCalc._firstChoice(expChoice);
        List[] listArray = new List[expChoice.getChoices().size()];
        List[] listArray2 = new List[expChoice.getChoices().size()];
        int[] nArray = new int[expChoice.getChoices().size() - 1];
        MatchInfo[] matchInfoArray = new MatchInfo[expChoice.getChoices().size() - 1];
        int[] nArray2 = new int[expChoice.getChoices().size() - 1];
        for (n = 1; n <= Options.getChoiceAmbiguityCheck(); ++n) {
            ArrayList<MatchInfo> arrayList;
            MatchInfo matchInfo;
            int n3;
            MatchInfo.s_laLimit = n;
            LookaheadWalk.s_considerSemanticLA = !Options.isForceLaCheck();
            for (n3 = n2; n3 < expChoice.getChoices().size() - 1; ++n3) {
                LookaheadWalk.s_sizeLimitedMatches = new ArrayList<MatchInfo>();
                matchInfo = new MatchInfo();
                matchInfo.m_firstFreeLoc = 0;
                arrayList = new ArrayList<MatchInfo>();
                arrayList.add(matchInfo);
                LookaheadWalk.genFirstSet(arrayList, expChoice.getChoices().get(n3));
                listArray[n3] = LookaheadWalk.s_sizeLimitedMatches;
            }
            LookaheadWalk.s_considerSemanticLA = false;
            for (n3 = n2 + 1; n3 < expChoice.getChoices().size(); ++n3) {
                LookaheadWalk.s_sizeLimitedMatches = new ArrayList<MatchInfo>();
                matchInfo = new MatchInfo();
                matchInfo.m_firstFreeLoc = 0;
                arrayList = new ArrayList();
                arrayList.add(matchInfo);
                LookaheadWalk.genFirstSet(arrayList, expChoice.getChoices().get(n3));
                listArray2[n3] = LookaheadWalk.s_sizeLimitedMatches;
            }
            if (n == 1) {
                for (n3 = n2; n3 < expChoice.getChoices().size() - 1; ++n3) {
                    Expansion expansion = expChoice.getChoices().get(n3);
                    if (Semanticize.emptyExpansionExists(expansion)) {
                        JavaCCErrors.warning(expansion, "This choice can expand to the empty token sequence and will therefore always be taken in favor of the choices appearing later.");
                        break;
                    }
                    if (!LookaheadCalc._isJavaCodeCheck(listArray[n3])) continue;
                    JavaCCErrors.warning(expansion, "JAVACODE non-terminal will force this choice to be taken in favor of the choices appearing later.");
                    break;
                }
            }
            boolean bl = false;
            block4: for (n3 = n2; n3 < expChoice.getChoices().size() - 1; ++n3) {
                for (int i = n3 + 1; i < expChoice.getChoices().size(); ++i) {
                    matchInfo = LookaheadCalc._overlap(listArray[n3], listArray2[i]);
                    if (matchInfo == null) continue;
                    nArray[n3] = n + 1;
                    matchInfoArray[n3] = matchInfo;
                    nArray2[n3] = i;
                    bl = true;
                    continue block4;
                }
            }
            if (!bl) break;
        }
        for (n = n2; n < expChoice.getChoices().size() - 1; ++n) {
            Expansion expansion = expChoice.getChoices().get(n);
            if (LookaheadCalc._explicitLA(expansion) && !Options.isForceLaCheck()) continue;
            if (nArray[n] > Options.getChoiceAmbiguityCheck()) {
                JavaCCErrors.warning("Choice conflict involving two expansions at");
                PGPrinter.error("         line " + expansion.getLine() + ", column " + expansion.getColumn() + " and line " + expChoice.getChoices().get(nArray2[n]).getLine() + ", column " + expChoice.getChoices().get(nArray2[n]).getColumn() + " respectively.");
                PGPrinter.error("         A common prefix is: " + LookaheadCalc._image(matchInfoArray[n]));
                PGPrinter.error("         Consider using a lookahead of " + nArray[n] + " or more for earlier expansion.");
                continue;
            }
            if (nArray[n] <= 1) continue;
            JavaCCErrors.warning("Choice conflict involving two expansions at");
            PGPrinter.error("         line " + expansion.getLine() + ", column " + expansion.getColumn() + " and line " + expChoice.getChoices().get(nArray2[n]).getLine() + ", column " + expChoice.getChoices().get(nArray2[n]).getColumn() + " respectively.");
            PGPrinter.error("         A common prefix is: " + LookaheadCalc._image(matchInfoArray[n]));
            PGPrinter.error("         Consider using a lookahead of " + nArray[n] + " for earlier expansion.");
        }
    }

    private static boolean _explicitLA(Expansion expansion) {
        if (!(expansion instanceof ExpSequence)) {
            return false;
        }
        ExpSequence expSequence = (ExpSequence)expansion;
        Expansion expansion2 = expSequence.m_units.get(0);
        if (!(expansion2 instanceof ExpLookahead)) {
            return false;
        }
        ExpLookahead expLookahead = (ExpLookahead)expansion2;
        return expLookahead.isExplicit();
    }

    private static int _firstChoice(ExpChoice expChoice) {
        if (Options.isForceLaCheck()) {
            return 0;
        }
        for (int i = 0; i < expChoice.getChoices().size(); ++i) {
            if (LookaheadCalc._explicitLA(expChoice.getChoices().get(i))) continue;
            return i;
        }
        return expChoice.getChoices().size();
    }

    @Nonnull
    private static String _image(Expansion expansion) {
        if (expansion instanceof ExpOneOrMore) {
            return "(...)+";
        }
        if (expansion instanceof ExpZeroOrMore) {
            return "(...)*";
        }
        assert (expansion instanceof ExpZeroOrOne);
        return "[...]";
    }

    public static void ebnfCalc(Expansion expansion, Expansion expansion2) {
        int n;
        MatchInfo matchInfo = null;
        for (n = 1; n <= Options.getOtherAmbiguityCheck(); ++n) {
            MatchInfo.s_laLimit = n;
            LookaheadWalk.s_sizeLimitedMatches = new ArrayList<MatchInfo>();
            MatchInfo matchInfo2 = new MatchInfo();
            matchInfo2.m_firstFreeLoc = 0;
            ArrayList<MatchInfo> arrayList = new ArrayList<MatchInfo>();
            arrayList.add(matchInfo2);
            LookaheadWalk.s_considerSemanticLA = !Options.isForceLaCheck();
            LookaheadWalk.genFirstSet(arrayList, expansion2);
            List<MatchInfo> list = LookaheadWalk.s_sizeLimitedMatches;
            LookaheadWalk.s_sizeLimitedMatches = new ArrayList<MatchInfo>();
            LookaheadWalk.s_considerSemanticLA = false;
            LookaheadWalk.genFollowSet(arrayList, expansion, Expansion.getNextGenerationIndex());
            List<MatchInfo> list2 = LookaheadWalk.s_sizeLimitedMatches;
            if (n == 1 && LookaheadCalc._isJavaCodeCheck(list)) {
                JavaCCErrors.warning(expansion2, "JAVACODE non-terminal within " + LookaheadCalc._image(expansion) + " construct will force this construct to be entered in favor of expansions occurring after construct.");
            }
            if ((matchInfo2 = LookaheadCalc._overlap(list, list2)) == null) break;
            matchInfo = matchInfo2;
        }
        if (n > Options.getOtherAmbiguityCheck()) {
            JavaCCErrors.warning("Choice conflict in " + LookaheadCalc._image(expansion) + " construct at line " + expansion.getLine() + ", column " + expansion.getColumn() + ".");
            PGPrinter.error("         Expansion nested within construct and expansion following construct");
            PGPrinter.error("         have common prefixes, one of which is: " + LookaheadCalc._image(matchInfo));
            PGPrinter.error("         Consider using a lookahead of " + n + " or more for nested expansion.");
        } else if (n > 1) {
            JavaCCErrors.warning("Choice conflict in " + LookaheadCalc._image(expansion) + " construct at line " + expansion.getLine() + ", column " + expansion.getColumn() + ".");
            PGPrinter.error("         Expansion nested within construct and expansion following construct");
            PGPrinter.error("         have common prefixes, one of which is: " + LookaheadCalc._image(matchInfo));
            PGPrinter.error("         Consider using a lookahead of " + n + " for nested expansion.");
        }
    }
}

