/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nepxion.discovery.common.handler.RestErrorHandler;
import com.nepxion.discovery.common.util.JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RestUtil {
    public static <T> T fromJson(RestTemplate restTemplate, String result, TypeReference<T> typeReference) {
        try {
            return JsonUtil.fromJson(result, typeReference);
        }
        catch (Exception e) {
            String cause = RestUtil.getCause(restTemplate);
            if (StringUtils.isNotEmpty((CharSequence)cause)) {
                throw new IllegalArgumentException(cause);
            }
            throw e;
        }
    }

    public static String getCause(RestTemplate restTemplate) {
        ResponseErrorHandler responseErrorHandler = restTemplate.getErrorHandler();
        if (responseErrorHandler instanceof RestErrorHandler) {
            RestErrorHandler errorHandler = (RestErrorHandler)responseErrorHandler;
            return errorHandler.getCause();
        }
        return null;
    }
}

