/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson;

import com.owlike.genson.BeanView;
import com.owlike.genson.Converter;
import com.owlike.genson.Deserializer;
import com.owlike.genson.Factory;
import com.owlike.genson.GenericType;
import com.owlike.genson.Genson;
import com.owlike.genson.Serializer;
import com.owlike.genson.convert.BasicConvertersFactory;
import com.owlike.genson.convert.BeanViewConverter;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.convert.CircularClassReferenceConverterFactory;
import com.owlike.genson.convert.ClassMetadataConverter;
import com.owlike.genson.convert.ContextualFactory;
import com.owlike.genson.convert.DefaultConverters;
import com.owlike.genson.convert.NullConverter;
import com.owlike.genson.convert.RuntimeTypeConverter;
import com.owlike.genson.ext.GensonBundle;
import com.owlike.genson.reflect.ASMCreatorParameterNameResolver;
import com.owlike.genson.reflect.AbstractBeanDescriptorProvider;
import com.owlike.genson.reflect.BaseBeanDescriptorProvider;
import com.owlike.genson.reflect.BeanDescriptorProvider;
import com.owlike.genson.reflect.BeanMutatorAccessorResolver;
import com.owlike.genson.reflect.BeanPropertyFactory;
import com.owlike.genson.reflect.BeanViewDescriptorProvider;
import com.owlike.genson.reflect.PropertyFilter;
import com.owlike.genson.reflect.PropertyNameResolver;
import com.owlike.genson.reflect.RenamingPropertyNameResolver;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.reflect.VisibilityFilter;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GensonBuilder {
    private final Map<Type, Serializer<?>> serializersMap = new HashMap();
    private final Map<Type, Deserializer<?>> deserializersMap = new HashMap();
    private final List<Factory<?>> converterFactories = new ArrayList();
    private final List<ContextualFactory<?>> contextualFactories = new ArrayList();
    private final List<BeanPropertyFactory> beanPropertyFactories = new ArrayList<BeanPropertyFactory>();
    private boolean skipNull = false;
    private boolean htmlSafe = false;
    private boolean withClassMetadata = false;
    private boolean throwExcOnNoDebugInfo = false;
    private boolean useGettersAndSetters = true;
    private boolean useFields = true;
    private boolean withBeanViewConverter = false;
    private boolean useRuntimeTypeForSerialization = false;
    private boolean withDebugInfoPropertyNameResolver = false;
    private boolean strictDoubleParse = false;
    private boolean indent = false;
    private boolean metadata = false;
    private boolean failOnMissingProperty = false;
    private boolean permissiveParsing = false;
    private List<GensonBundle> _bundles = new ArrayList<GensonBundle>();
    private PropertyNameResolver propertyNameResolver;
    private BeanMutatorAccessorResolver mutatorAccessorResolver;
    private VisibilityFilter propertyFilter = VisibilityFilter.PACKAGE_PUBLIC;
    private VisibilityFilter methodFilter = VisibilityFilter.PACKAGE_PUBLIC;
    private VisibilityFilter constructorFilter = VisibilityFilter.PACKAGE_PUBLIC;
    private BeanDescriptorProvider beanDescriptorProvider;
    private Converter<Object> nullConverter;
    private DateFormat dateFormat = SimpleDateFormat.getDateInstance();
    private boolean useDateAsTimestamp;
    private boolean classMetadataWithStaticType = true;
    private BeanViewDescriptorProvider beanViewDescriptorProvider;
    private final Map<String, Class<?>> withClassAliases = new HashMap();
    private final Map<Class<?>, BeanView<?>> registeredViews = new HashMap();

    public GensonBuilder addAlias(String alias, Class<?> forClass) {
        this.withClassMetadata = true;
        this.withClassAliases.put(alias, forClass);
        return this;
    }

    public GensonBuilder withConverters(Converter<?> ... converter) {
        for (Converter<?> c : converter) {
            Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Converter.class, c.getClass()));
            typeOfConverter = TypeUtil.expandType(typeOfConverter, c.getClass());
            this.registerConverter(c, typeOfConverter);
        }
        return this;
    }

    public <T> GensonBuilder withConverter(Converter<T> converter, Class<? extends T> type) {
        this.registerConverter(converter, type);
        return this;
    }

    public <T> GensonBuilder withConverter(Converter<T> converter, GenericType<? extends T> type) {
        this.registerConverter(converter, type.getType());
        return this;
    }

    private <T> void registerConverter(Converter<T> converter, Type type) {
        if (this.serializersMap.containsKey(type)) {
            throw new IllegalStateException("Can not register converter " + converter.getClass() + ". A custom serializer is already registered for type " + type);
        }
        if (this.deserializersMap.containsKey(type)) {
            throw new IllegalStateException("Can not register converter " + converter.getClass() + ". A custom deserializer is already registered for type " + type);
        }
        this.serializersMap.put(type, converter);
        this.deserializersMap.put(type, converter);
    }

    public GensonBuilder withSerializers(Serializer<?> ... serializer) {
        for (Serializer<?> s : serializer) {
            Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Serializer.class, s.getClass()));
            typeOfConverter = TypeUtil.expandType(typeOfConverter, s.getClass());
            this.registerSerializer(s, typeOfConverter);
        }
        return this;
    }

    public <T> GensonBuilder withSerializer(Serializer<T> serializer, Class<? extends T> type) {
        this.registerSerializer(serializer, type);
        return this;
    }

    public <T> GensonBuilder withSerializer(Serializer<T> serializer, GenericType<? extends T> type) {
        this.registerSerializer(serializer, type.getType());
        return this;
    }

    private <T> void registerSerializer(Serializer<T> serializer, Type type) {
        if (this.serializersMap.containsKey(type)) {
            throw new IllegalStateException("Can not register serializer " + serializer.getClass() + ". A custom serializer is already registered for type " + type);
        }
        this.serializersMap.put(type, serializer);
    }

    public GensonBuilder withDeserializers(Deserializer<?> ... deserializer) {
        for (Deserializer<?> d : deserializer) {
            Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Deserializer.class, d.getClass()));
            typeOfConverter = TypeUtil.expandType(typeOfConverter, d.getClass());
            this.registerDeserializer(d, typeOfConverter);
        }
        return this;
    }

    public <T> GensonBuilder withDeserializer(Deserializer<T> deserializer, Class<? extends T> type) {
        this.registerDeserializer(deserializer, type);
        return this;
    }

    public <T> GensonBuilder withDeserializer(Deserializer<T> deserializer, GenericType<? extends T> type) {
        this.registerDeserializer(deserializer, type.getType());
        return this;
    }

    private <T> void registerDeserializer(Deserializer<T> deserializer, Type type) {
        if (this.deserializersMap.containsKey(type)) {
            throw new IllegalStateException("Can not register deserializer " + deserializer.getClass() + ". A custom deserializer is already registered for type " + type);
        }
        this.deserializersMap.put(type, deserializer);
    }

    public GensonBuilder withConverterFactory(Factory<? extends Converter<?>> factory) {
        this.converterFactories.add(factory);
        return this;
    }

    public GensonBuilder withSerializerFactory(Factory<? extends Serializer<?>> factory) {
        this.converterFactories.add(factory);
        return this;
    }

    public GensonBuilder withDeserializerFactory(Factory<? extends Deserializer<?>> factory) {
        this.converterFactories.add(factory);
        return this;
    }

    public GensonBuilder withContextualFactory(ContextualFactory<?> ... factories) {
        this.contextualFactories.addAll(Arrays.asList(factories));
        return this;
    }

    public GensonBuilder withBeanPropertyFactory(BeanPropertyFactory ... factories) {
        this.beanPropertyFactories.addAll(Arrays.asList(factories));
        return this;
    }

    public GensonBuilder withBundle(GensonBundle ... bundles) {
        for (GensonBundle ext : bundles) {
            this._bundles.add(ext);
        }
        return this;
    }

    public GensonBuilder set(BeanMutatorAccessorResolver resolver) {
        this.mutatorAccessorResolver = resolver;
        return this;
    }

    public GensonBuilder set(PropertyNameResolver resolver) {
        this.propertyNameResolver = resolver;
        return this;
    }

    public GensonBuilder with(BeanMutatorAccessorResolver ... resolvers) {
        if (this.mutatorAccessorResolver == null) {
            this.mutatorAccessorResolver = this.createBeanMutatorAccessorResolver();
        }
        if (!(this.mutatorAccessorResolver instanceof BeanMutatorAccessorResolver.CompositeResolver)) {
            throw new IllegalStateException("You can not add multiple resolvers if the base resolver is not of type " + BeanMutatorAccessorResolver.CompositeResolver.class.getName());
        }
        ((BeanMutatorAccessorResolver.CompositeResolver)this.mutatorAccessorResolver).add(resolvers);
        return this;
    }

    public Map<Type, Serializer<?>> getSerializersMap() {
        return Collections.unmodifiableMap(this.serializersMap);
    }

    public Map<Type, Deserializer<?>> getDeserializersMap() {
        return Collections.unmodifiableMap(this.deserializersMap);
    }

    public GensonBuilder with(PropertyNameResolver ... resolvers) {
        if (this.propertyNameResolver == null) {
            this.propertyNameResolver = this.createPropertyNameResolver();
        }
        if (!(this.propertyNameResolver instanceof PropertyNameResolver.CompositePropertyNameResolver)) {
            throw new IllegalStateException("You can not add multiple resolvers if the base resolver is not of type " + PropertyNameResolver.CompositePropertyNameResolver.class.getName());
        }
        ((PropertyNameResolver.CompositePropertyNameResolver)this.propertyNameResolver).add(resolvers);
        return this;
    }

    public GensonBuilder rename(String field, String toName) {
        return this.rename(field, null, toName, null);
    }

    public GensonBuilder rename(Class<?> fieldOfType, String toName) {
        return this.rename(null, null, toName, fieldOfType);
    }

    public GensonBuilder rename(String field, Class<?> fromClass, String toName) {
        return this.rename(field, fromClass, toName, null);
    }

    public GensonBuilder rename(String field, String toName, Class<?> fieldOfType) {
        return this.rename(field, null, toName, fieldOfType);
    }

    public GensonBuilder rename(String field, Class<?> fromClass, String toName, Class<?> ofType) {
        return this.with(new RenamingPropertyNameResolver(field, fromClass, ofType, toName));
    }

    public GensonBuilder exclude(String field) {
        return this.filter(field, null, null, true);
    }

    public GensonBuilder exclude(Class<?> fieldOfType) {
        return this.filter(null, null, fieldOfType, true);
    }

    public GensonBuilder exclude(String field, Class<?> fromClass) {
        return this.filter(field, fromClass, null, true);
    }

    public GensonBuilder exclude(String field, Class<?> fromClass, Class<?> ofType) {
        return this.filter(field, fromClass, ofType, true);
    }

    public GensonBuilder include(String field) {
        return this.filter(field, null, null, false);
    }

    public GensonBuilder include(Class<?> fieldOfType) {
        return this.filter(null, null, fieldOfType, false);
    }

    public GensonBuilder include(String field, Class<?> fromClass) {
        return this.filter(field, fromClass, null, false);
    }

    public GensonBuilder include(String field, Class<?> fromClass, Class<?> ofType) {
        return this.filter(field, fromClass, ofType, false);
    }

    private GensonBuilder filter(String field, Class<?> declaringClass, Class<?> ofType, boolean exclude) {
        return this.with(new PropertyFilter(exclude, field, declaringClass, ofType));
    }

    public GensonBuilder setSkipNull(boolean skipNull) {
        this.skipNull = skipNull;
        return this;
    }

    public boolean isSkipNull() {
        return this.skipNull;
    }

    public GensonBuilder setHtmlSafe(boolean htmlSafe) {
        this.htmlSafe = htmlSafe;
        return this;
    }

    public boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public GensonBuilder useClassMetadata(boolean enabled) {
        this.withClassMetadata = enabled;
        this.metadata = true;
        return this;
    }

    public GensonBuilder useDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public boolean isThrowExceptionOnNoDebugInfo() {
        return this.throwExcOnNoDebugInfo;
    }

    public GensonBuilder setThrowExceptionIfNoDebugInfo(boolean throwExcOnNoDebugInfo) {
        this.throwExcOnNoDebugInfo = throwExcOnNoDebugInfo;
        return this;
    }

    public GensonBuilder useMethods(boolean enabled) {
        this.useGettersAndSetters = enabled;
        return this;
    }

    public GensonBuilder useMethods(boolean enabled, VisibilityFilter visibility) {
        this.useMethods(enabled);
        return this.setMethodFilter(visibility);
    }

    public GensonBuilder useFields(boolean enabled) {
        this.useFields = enabled;
        return this;
    }

    public GensonBuilder useFields(boolean enabled, VisibilityFilter visibility) {
        this.useFields(enabled);
        return this.setFieldFilter(visibility);
    }

    public GensonBuilder useBeanViews(boolean enabled) {
        this.withBeanViewConverter = enabled;
        return this;
    }

    public GensonBuilder useRuntimeType(boolean enabled) {
        this.useRuntimeTypeForSerialization = enabled;
        return this;
    }

    public GensonBuilder useConstructorWithArguments(boolean enabled) {
        this.withDebugInfoPropertyNameResolver = enabled;
        return this;
    }

    public GensonBuilder setNullConverter(Converter<Object> nullConverter) {
        this.nullConverter = nullConverter;
        return this;
    }

    public GensonBuilder setFieldFilter(VisibilityFilter propertyFilter) {
        this.propertyFilter = propertyFilter;
        return this;
    }

    public GensonBuilder setMethodFilter(VisibilityFilter methodFilter) {
        this.methodFilter = methodFilter;
        return this;
    }

    public GensonBuilder setConstructorFilter(VisibilityFilter constructorFilter) {
        this.constructorFilter = constructorFilter;
        return this;
    }

    public GensonBuilder useStrictDoubleParse(boolean strictDoubleParse) {
        this.strictDoubleParse = strictDoubleParse;
        return this;
    }

    public GensonBuilder useIndentation(boolean indent) {
        this.indent = indent;
        return this;
    }

    public GensonBuilder useDateAsTimestamp(boolean enabled) {
        this.useDateAsTimestamp = enabled;
        return this;
    }

    public GensonBuilder useMetadata(boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    public GensonBuilder useByteAsInt(boolean enable) {
        if (enable) {
            this.withConverters(DefaultConverters.ByteArrayAsIntArrayConverter.instance);
        }
        return this;
    }

    public GensonBuilder failOnMissingProperty(boolean enable) {
        this.failOnMissingProperty = enable;
        return this;
    }

    public GensonBuilder useClassMetadataWithStaticType(boolean enable) {
        this.classMetadataWithStaticType = enable;
        return this;
    }

    public GensonBuilder usePermissiveParsing(boolean enable) {
        this.permissiveParsing = enable;
        return this;
    }

    public Genson create() {
        for (GensonBundle bundle : this._bundles) {
            bundle.configure(this);
        }
        if (this.nullConverter == null) {
            this.nullConverter = new NullConverter();
        }
        if (this.propertyNameResolver == null) {
            this.propertyNameResolver = this.createPropertyNameResolver();
        }
        if (this.mutatorAccessorResolver == null) {
            this.mutatorAccessorResolver = this.createBeanMutatorAccessorResolver();
        }
        List<Converter<?>> converters = this.getDefaultConverters();
        this.addDefaultSerializers(converters);
        this.addDefaultDeserializers(converters);
        this.addDefaultSerializers(this.getDefaultSerializers());
        this.addDefaultDeserializers(this.getDefaultDeserializers());
        ArrayList convFactories = new ArrayList();
        this.addDefaultConverterFactories(convFactories);
        this.converterFactories.addAll(convFactories);
        ArrayList serializerFactories = new ArrayList();
        this.addDefaultSerializerFactories(serializerFactories);
        this.converterFactories.addAll(serializerFactories);
        ArrayList deserializerFactories = new ArrayList();
        this.addDefaultDeserializerFactories(deserializerFactories);
        this.converterFactories.addAll(deserializerFactories);
        ArrayList defaultContextualFactories = new ArrayList();
        this.addDefaultContextualFactories(defaultContextualFactories);
        this.contextualFactories.addAll(defaultContextualFactories);
        this.beanDescriptorProvider = this.createBeanDescriptorProvider();
        if (this.withBeanViewConverter) {
            ArrayList<BeanMutatorAccessorResolver> resolvers = new ArrayList<BeanMutatorAccessorResolver>();
            resolvers.add(new BeanViewDescriptorProvider.BeanViewMutatorAccessorResolver());
            resolvers.add(this.mutatorAccessorResolver);
            this.beanViewDescriptorProvider = new BeanViewDescriptorProvider(new AbstractBeanDescriptorProvider.ContextualConverterFactory(this.contextualFactories), this.registeredViews, this.createBeanPropertyFactory(), new BeanMutatorAccessorResolver.CompositeResolver(resolvers), this.getPropertyNameResolver());
        }
        return this.create(this.createConverterFactory(), this.withClassAliases);
    }

    private void addDefaultSerializers(List<? extends Serializer<?>> serializers) {
        if (serializers != null) {
            for (Serializer<?> serializer : serializers) {
                Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Serializer.class, serializer.getClass()));
                if (this.serializersMap.containsKey(typeOfConverter = TypeUtil.expandType(typeOfConverter, serializer.getClass()))) continue;
                this.serializersMap.put(typeOfConverter, serializer);
            }
        }
    }

    private void addDefaultDeserializers(List<? extends Deserializer<?>> deserializers) {
        if (deserializers != null) {
            for (Deserializer<?> deserializer : deserializers) {
                Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Deserializer.class, deserializer.getClass()));
                if (this.deserializersMap.containsKey(typeOfConverter = TypeUtil.expandType(typeOfConverter, deserializer.getClass()))) continue;
                this.deserializersMap.put(typeOfConverter, deserializer);
            }
        }
    }

    protected Genson create(Factory<Converter<?>> converterFactory, Map<String, Class<?>> classAliases) {
        return new Genson(converterFactory, this.getBeanDescriptorProvider(), this.nullConverter, this.isSkipNull(), this.isHtmlSafe(), classAliases, this.withClassMetadata, this.strictDoubleParse, this.indent, this.metadata, this.failOnMissingProperty, this.permissiveParsing);
    }

    protected Factory<Converter<?>> createConverterFactory() {
        CircularClassReferenceConverterFactory chainHead = new CircularClassReferenceConverterFactory();
        ChainedFactory chainTail = chainHead;
        chainTail = chainTail.withNext(new NullConverter.NullConverterFactory());
        if (this.useRuntimeTypeForSerialization) {
            chainTail = chainTail.withNext(new RuntimeTypeConverter.RuntimeTypeConverterFactory());
        }
        chainTail = chainTail.withNext(new ClassMetadataConverter.ClassMetadataConverterFactory(this.classMetadataWithStaticType));
        if (this.withBeanViewConverter) {
            chainTail = chainTail.withNext(new BeanViewConverter.BeanViewConverterFactory(this.getBeanViewDescriptorProvider()));
        }
        AbstractBeanDescriptorProvider.ContextualFactoryDecorator ctxFactoryDecorator = new AbstractBeanDescriptorProvider.ContextualFactoryDecorator(new BasicConvertersFactory(this.getSerializersMap(), this.getDeserializersMap(), this.getFactories(), this.getBeanDescriptorProvider()));
        chainTail.withNext(ctxFactoryDecorator);
        return chainHead;
    }

    protected BeanMutatorAccessorResolver createBeanMutatorAccessorResolver() {
        ArrayList<BeanMutatorAccessorResolver> resolvers = new ArrayList<BeanMutatorAccessorResolver>();
        resolvers.add(new BeanMutatorAccessorResolver.GensonAnnotationsResolver());
        resolvers.add(new BeanMutatorAccessorResolver.StandardMutaAccessorResolver(this.propertyFilter, this.methodFilter, this.constructorFilter));
        return new BeanMutatorAccessorResolver.CompositeResolver(resolvers);
    }

    protected PropertyNameResolver createPropertyNameResolver() {
        ArrayList<PropertyNameResolver> resolvers = new ArrayList<PropertyNameResolver>();
        resolvers.add(new PropertyNameResolver.AnnotationPropertyNameResolver());
        resolvers.add(new PropertyNameResolver.ConventionalBeanPropertyNameResolver());
        if (this.withDebugInfoPropertyNameResolver) {
            resolvers.add(new ASMCreatorParameterNameResolver(this.isThrowExceptionOnNoDebugInfo()));
        }
        return new PropertyNameResolver.CompositePropertyNameResolver(resolvers);
    }

    protected List<Converter<?>> getDefaultConverters() {
        ArrayList converters = new ArrayList();
        converters.add(DefaultConverters.StringConverter.instance);
        converters.add(DefaultConverters.BooleanConverter.instance);
        converters.add(DefaultConverters.IntegerConverter.instance);
        converters.add(DefaultConverters.DoubleConverter.instance);
        converters.add(DefaultConverters.LongConverter.instance);
        converters.add(DefaultConverters.ShortConverter.instance);
        converters.add(DefaultConverters.FloatConverter.instance);
        converters.add(DefaultConverters.NumberConverter.instance);
        converters.add(DefaultConverters.CharConverter.instance);
        converters.add(DefaultConverters.ByteConverter.instance);
        converters.add(new DefaultConverters.DateConverter(this.dateFormat, this.useDateAsTimestamp));
        converters.add(DefaultConverters.URLConverter.instance);
        converters.add(DefaultConverters.URIConverter.instance);
        converters.add(DefaultConverters.TimestampConverter.instance);
        converters.add(DefaultConverters.BigDecimalConverter.instance);
        converters.add(DefaultConverters.BigIntegerConverter.instance);
        converters.add(DefaultConverters.UUIDConverter.instance);
        converters.add(DefaultConverters.FileConverter.instance);
        return converters;
    }

    protected void addDefaultConverterFactories(List<Factory<? extends Converter<?>>> factories) {
        factories.add(DefaultConverters.ArrayConverterFactory.instance);
        factories.add(DefaultConverters.CollectionConverterFactory.instance);
        factories.add(DefaultConverters.MapConverterFactory.instance);
        factories.add(DefaultConverters.EnumConverterFactory.instance);
        factories.add(DefaultConverters.PrimitiveConverterFactory.instance);
        factories.add(DefaultConverters.UntypedConverterFactory.instance);
        factories.add(new DefaultConverters.CalendarConverterFactory(new DefaultConverters.DateConverter(this.dateFormat, this.useDateAsTimestamp)));
    }

    protected void addDefaultContextualFactories(List<ContextualFactory<?>> factories) {
        factories.add(new DefaultConverters.DateContextualFactory());
        factories.add(new DefaultConverters.PropertyConverterFactory());
    }

    protected List<Serializer<?>> getDefaultSerializers() {
        return null;
    }

    protected void addDefaultSerializerFactories(List<Factory<? extends Serializer<?>>> serializerFactories) {
    }

    protected List<Deserializer<?>> getDefaultDeserializers() {
        return null;
    }

    protected void addDefaultDeserializerFactories(List<Factory<? extends Deserializer<?>>> deserializerFactories) {
    }

    protected BeanDescriptorProvider createBeanDescriptorProvider() {
        AbstractBeanDescriptorProvider.ContextualConverterFactory contextualConverterFactory = new AbstractBeanDescriptorProvider.ContextualConverterFactory(this.contextualFactories);
        BeanPropertyFactory beanPropertyFactory = this.createBeanPropertyFactory();
        ArrayList<BeanDescriptorProvider> providers = new ArrayList<BeanDescriptorProvider>();
        for (GensonBundle bundle : this._bundles) {
            BeanDescriptorProvider provider = bundle.createBeanDescriptorProvider(contextualConverterFactory, beanPropertyFactory, this.getMutatorAccessorResolver(), this.getPropertyNameResolver(), this);
            if (provider == null) continue;
            providers.add(provider);
        }
        providers.add(new BaseBeanDescriptorProvider(new AbstractBeanDescriptorProvider.ContextualConverterFactory(this.contextualFactories), this.createBeanPropertyFactory(), this.getMutatorAccessorResolver(), this.getPropertyNameResolver(), this.useGettersAndSetters, this.useFields, true));
        return new BeanDescriptorProvider.CompositeBeanDescriptorProvider(providers);
    }

    protected BeanPropertyFactory createBeanPropertyFactory() {
        if (this.withBeanViewConverter) {
            this.beanPropertyFactories.add(new BeanViewDescriptorProvider.BeanViewPropertyFactory(this.registeredViews));
        }
        this.beanPropertyFactories.add(new BeanPropertyFactory.StandardFactory());
        return new BeanPropertyFactory.CompositeFactory(this.beanPropertyFactories);
    }

    protected final PropertyNameResolver getPropertyNameResolver() {
        return this.propertyNameResolver;
    }

    protected final BeanMutatorAccessorResolver getMutatorAccessorResolver() {
        return this.mutatorAccessorResolver;
    }

    protected final BeanDescriptorProvider getBeanDescriptorProvider() {
        return this.beanDescriptorProvider;
    }

    protected final BeanViewDescriptorProvider getBeanViewDescriptorProvider() {
        return this.beanViewDescriptorProvider;
    }

    public final List<Factory<?>> getFactories() {
        return Collections.unmodifiableList(this.converterFactories);
    }

    public final boolean isDateAsTimestamp() {
        return this.useDateAsTimestamp;
    }
}

