/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.JsonBindingException;
import com.owlike.genson.Wrapper;
import com.owlike.genson.annotation.HandleClassMetadata;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import com.owlike.genson.stream.ValueType;
import java.lang.reflect.Type;

public class ClassMetadataConverter<T>
extends Wrapper<Converter<T>>
implements Converter<T> {
    private final boolean classMetadataWithStaticType;
    private final Class<T> tClass;

    public ClassMetadataConverter(Class<T> tClass, Converter<T> delegate, boolean classMetadataWithStaticType) {
        super(delegate);
        this.tClass = tClass;
        this.classMetadataWithStaticType = classMetadataWithStaticType;
    }

    @Override
    public void serialize(T obj, ObjectWriter writer, Context ctx) throws Exception {
        if (obj != null && (this.classMetadataWithStaticType || !this.classMetadataWithStaticType && !this.tClass.equals(obj.getClass()))) {
            writer.beginNextObjectMetadata().writeMetadata("class", ctx.genson.aliasFor(obj.getClass()));
        }
        ((Converter)this.wrapped).serialize(obj, writer, ctx);
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) throws Exception {
        String className;
        if (ValueType.OBJECT.equals((Object)reader.getValueType()) && (className = reader.nextObjectMetadata().metadata("class")) != null) {
            try {
                Class<?> classFromMetadata = ctx.genson.classFor(className);
                if (!classFromMetadata.equals(this.tClass)) {
                    Converter deser = ctx.genson.provideConverter(classFromMetadata);
                    return deser.deserialize(reader, ctx);
                }
            }
            catch (ClassNotFoundException e) {
                throw new JsonBindingException("Could not use @class metadata, no such class: " + className);
            }
        }
        return ((Converter)this.wrapped).deserialize(reader, ctx);
    }

    public static class ClassMetadataConverterFactory
    extends ChainedFactory {
        private final boolean classMetadataWithStaticType;

        public ClassMetadataConverterFactory(boolean classMetadataWithStaticType) {
            this.classMetadataWithStaticType = classMetadataWithStaticType;
        }

        @Override
        protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
            if (nextConverter == null) {
                throw new IllegalArgumentException("nextConverter must be not null for ClassMetadataConverter, as ClassMetadataConverter can not be the last converter in the chain!");
            }
            Class<?> rawClass = TypeUtil.getRawClass(type);
            if (genson.isWithClassMetadata() && !Wrapper.toAnnotatedElement(nextConverter).isAnnotationPresent(HandleClassMetadata.class)) {
                return new ClassMetadataConverter(rawClass, nextConverter, this.classMetadataWithStaticType);
            }
            return nextConverter;
        }
    }
}

