/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.HashSet;
import java.util.Set;

@FileStatefulCheck
public class RedundantImportCheck
extends AbstractCheck {
    public static final String MSG_LANG = "import.lang";
    public static final String MSG_SAME = "import.same";
    public static final String MSG_DUPLICATE = "import.duplicate";
    private final Set<FullIdent> imports = new HashSet<FullIdent>();
    private final Set<FullIdent> staticImports = new HashSet<FullIdent>();
    private String pkgName;

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.pkgName = null;
        this.imports.clear();
        this.staticImports.clear();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 152, 16};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            this.pkgName = FullIdent.createFullIdent(ast.getLastChild().getPreviousSibling()).getText();
        } else if (ast.getType() == 30) {
            FullIdent imp = FullIdent.createFullIdentBelow(ast);
            if (RedundantImportCheck.isFromPackage(imp.getText(), "java.lang")) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_LANG, imp.getText());
            } else if (this.pkgName != null && RedundantImportCheck.isFromPackage(imp.getText(), this.pkgName)) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_SAME, imp.getText());
            }
            this.imports.stream().filter(full -> imp.getText().equals(full.getText())).forEach(full -> this.log(ast.getLineNo(), ast.getColumnNo(), MSG_DUPLICATE, full.getLineNo(), imp.getText()));
            this.imports.add(imp);
        } else {
            FullIdent imp = FullIdent.createFullIdent(ast.getLastChild().getPreviousSibling());
            this.staticImports.stream().filter(full -> imp.getText().equals(full.getText())).forEach(full -> this.log(ast.getLineNo(), ast.getColumnNo(), MSG_DUPLICATE, full.getLineNo(), imp.getText()));
            this.staticImports.add(imp);
        }
    }

    private static boolean isFromPackage(String importName, String pkg) {
        int index = importName.lastIndexOf(46);
        String front = importName.substring(0, index);
        return front.equals(pkg);
    }
}

