/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayDeque;
import java.util.Deque;

@FileStatefulCheck
public class JavaNCSSCheck
extends AbstractCheck {
    public static final String MSG_METHOD = "ncss.method";
    public static final String MSG_CLASS = "ncss.class";
    public static final String MSG_FILE = "ncss.file";
    private static final int FILE_MAX_NCSS = 2000;
    private static final int CLASS_MAX_NCSS = 1500;
    private static final int METHOD_MAX_NCSS = 50;
    private int fileMaximum = 2000;
    private int classMaximum = 1500;
    private int methodMaximum = 50;
    private Deque<Counter> counters;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 15, 9, 8, 11, 12, 16, 30, 10, 43, 42, 83, 92, 84, 85, 91, 89, 86, 87, 88, 90, 67, 96, 97, 28, 22, 93, 94};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.counters = new ArrayDeque<Counter>();
        this.counters.push(new Counter());
    }

    @Override
    public void visitToken(DetailAST ast) {
        int tokenType = ast.getType();
        if (tokenType == 14 || tokenType == 9 || tokenType == 8 || tokenType == 12 || tokenType == 11) {
            this.counters.push(new Counter());
        }
        if (JavaNCSSCheck.isCountable(ast)) {
            this.counters.forEach(Counter::increment);
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        Counter counter;
        int count;
        int tokenType = ast.getType();
        if (tokenType == 9 || tokenType == 8 || tokenType == 12 || tokenType == 11) {
            Counter counter2 = this.counters.pop();
            int count2 = counter2.getCount();
            if (count2 > this.methodMaximum) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_METHOD, count2, this.methodMaximum);
            }
        } else if (tokenType == 14 && (count = (counter = this.counters.pop()).getCount()) > this.classMaximum) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_CLASS, count, this.classMaximum);
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        Counter counter = this.counters.pop();
        int count = counter.getCount();
        if (count > this.fileMaximum) {
            this.log(rootAST.getLineNo(), rootAST.getColumnNo(), MSG_FILE, count, this.fileMaximum);
        }
    }

    public void setFileMaximum(int fileMaximum) {
        this.fileMaximum = fileMaximum;
    }

    public void setClassMaximum(int classMaximum) {
        this.classMaximum = classMaximum;
    }

    public void setMethodMaximum(int methodMaximum) {
        this.methodMaximum = methodMaximum;
    }

    private static boolean isCountable(DetailAST ast) {
        boolean countable = true;
        int tokenType = ast.getType();
        if (tokenType == 28) {
            countable = JavaNCSSCheck.isExpressionCountable(ast);
        } else if (tokenType == 10) {
            countable = JavaNCSSCheck.isVariableDefCountable(ast);
        }
        return countable;
    }

    private static boolean isVariableDefCountable(DetailAST ast) {
        boolean countable = false;
        int parentType = ast.getParent().getType();
        if (parentType == 7 || parentType == 6) {
            DetailAST prevSibling = ast.getPreviousSibling();
            countable = prevSibling == null || prevSibling.getType() != 74;
        }
        return countable;
    }

    private static boolean isExpressionCountable(DetailAST ast) {
        boolean countable;
        int parentType = ast.getParent().getType();
        switch (parentType) {
            case 7: 
            case 22: 
            case 83: 
            case 84: 
            case 85: 
            case 91: 
            case 92: {
                DetailAST prevSibling = ast.getPreviousSibling();
                countable = prevSibling == null || prevSibling.getType() != 76;
                break;
            }
            default: {
                countable = false;
            }
        }
        return countable;
    }

    private static class Counter {
        private int count;

        private Counter() {
        }

        public void increment() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

