/*
 * Decompiled with CFR 0.152.
 */
package spark.resource;

import java.io.InputStream;
import java.net.MalformedURLException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.resource.AbstractResourceHandler;
import spark.resource.UriPath;
import spark.utils.Assert;

public class JarResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JarResourceHandler.class);
    private final String baseResource;
    private String welcomeFile;

    public JarResourceHandler(String baseResource, String welcomeFile) {
        Assert.notNull(baseResource);
        this.baseResource = baseResource;
        this.welcomeFile = welcomeFile;
    }

    public InputStream getResource(HttpServletRequest request) throws MalformedURLException {
        String pathInfo;
        String servletPath;
        boolean included;
        boolean bl = included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null && pathInfo == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        String pathInContext = AbstractResourceHandler.addPaths(servletPath, pathInfo);
        return this.getResourceStream(pathInContext);
    }

    private InputStream getResourceStream(String path) throws MalformedURLException {
        InputStream resourceStream;
        block6: {
            if (path == null || !path.startsWith("/")) {
                throw new MalformedURLException(path);
            }
            resourceStream = null;
            try {
                path = UriPath.canonical(path);
                path = AbstractResourceHandler.addPaths(this.baseResource, path);
                if (this.isDirectory(path)) {
                    if (this.welcomeFileConfigured()) {
                        path = AbstractResourceHandler.addPaths(path, this.welcomeFile);
                        resourceStream = this.loadStream(path);
                    }
                } else {
                    resourceStream = this.loadStream(path);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug(e.getClass().getSimpleName() + " when trying to get resource. " + e.getMessage());
            }
        }
        return resourceStream;
    }

    private InputStream loadStream(String path) {
        return JarResourceHandler.class.getResourceAsStream(path);
    }

    private boolean welcomeFileConfigured() {
        return this.welcomeFile != null;
    }

    private boolean isDirectory(String path) {
        return path.endsWith("/");
    }
}

