/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text;

import com.taobao.text.ScreenContext;
import com.taobao.text.Screenable;
import com.taobao.text.Style;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;

public class RenderWriter
extends Writer
implements Screenable {
    final ScreenContext out;
    private final Closeable closeable;
    private boolean closed;
    private boolean empty;

    public RenderWriter(ScreenContext out) throws NullPointerException {
        this(out, null);
    }

    public RenderWriter(ScreenContext out, Closeable closeable) throws NullPointerException {
        if (out == null) {
            throw new NullPointerException("No null appendable expected");
        }
        this.out = out;
        this.empty = true;
        this.closeable = closeable;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public RenderWriter append(CharSequence s) throws IOException {
        this.empty &= s.length() == 0;
        this.out.append(s);
        return this;
    }

    @Override
    public Screenable append(Style style) throws IOException {
        this.out.append(style);
        return this;
    }

    @Override
    public Screenable cls() throws IOException {
        this.out.cls();
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        if (len > 0) {
            this.out.append(new String(cbuf, off, len));
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.closeable != null) {
                this.closeable.close();
            }
        }
    }
}

