/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Bytes {
    private static final Pattern valuePattern = Pattern.compile("([0-9]+([\\.,][0-9]+)?)\\s*(|K|M|G|T)B?", 2);
    public static Bytes MAX = Bytes.bytes(Long.MAX_VALUE);
    private long value;

    private Bytes(long bytes) {
        this.value = bytes;
    }

    public static Bytes bytes(long bytes) {
        return new Bytes(bytes);
    }

    public static Bytes kilobytes(long kilobytes) {
        return Bytes.bytes(kilobytes * 1024L);
    }

    public static Bytes megabytes(long megabytes) {
        return Bytes.kilobytes(megabytes * 1024L);
    }

    public static Bytes gigabytes(long gigabytes) {
        return Bytes.megabytes(gigabytes * 1024L);
    }

    public static Bytes terabytes(long terabytes) {
        return Bytes.gigabytes(terabytes * 1024L);
    }

    public static Bytes bytes(double bytes) {
        return Bytes.bytes(Math.round(bytes));
    }

    public static Bytes kilobytes(double kilobytes) {
        return Bytes.bytes(kilobytes * 1024.0);
    }

    public static Bytes megabytes(double megabytes) {
        return Bytes.kilobytes(megabytes * 1024.0);
    }

    public static Bytes gigabytes(double gigabytes) {
        return Bytes.megabytes(gigabytes * 1024.0);
    }

    public static Bytes terabytes(double terabytes) {
        return Bytes.gigabytes(terabytes * 1024.0);
    }

    public final long bytes() {
        return this.value;
    }

    public final double kilobytes() {
        return (double)this.value / 1024.0;
    }

    public final double megabytes() {
        return this.kilobytes() / 1024.0;
    }

    public final double gigabytes() {
        return this.megabytes() / 1024.0;
    }

    public final double terabytes() {
        return this.gigabytes() / 1024.0;
    }

    public static Bytes valueOf(String string, Locale locale) throws NumberFormatException {
        Matcher matcher = valuePattern.matcher(string);
        if (matcher.matches()) {
            try {
                double value = NumberFormat.getNumberInstance(locale).parse(matcher.group(1)).doubleValue();
                String units = matcher.group(3);
                if (units.equalsIgnoreCase("")) {
                    return Bytes.bytes(value);
                }
                if (units.equalsIgnoreCase("K")) {
                    return Bytes.kilobytes(value);
                }
                if (units.equalsIgnoreCase("M")) {
                    return Bytes.megabytes(value);
                }
                if (units.equalsIgnoreCase("G")) {
                    return Bytes.gigabytes(value);
                }
                if (units.equalsIgnoreCase("T")) {
                    return Bytes.terabytes(value);
                }
                throw new NumberFormatException("Units not recognized: " + string);
            }
            catch (ParseException e) {
                throw new NumberFormatException("Unable to parse numeric part: " + string);
            }
        }
        throw new NumberFormatException("Unable to parse bytes: " + string);
    }

    public static Bytes valueOf(String string) throws NumberFormatException {
        return Bytes.valueOf(string, Locale.getDefault());
    }

    public String toString() {
        if (this.value >= 0L) {
            if (this.terabytes() >= 1.0) {
                return this.unitString(this.gigabytes(), "T");
            }
            if (this.gigabytes() >= 1.0) {
                return this.unitString(this.gigabytes(), "G");
            }
            if (this.megabytes() >= 1.0) {
                return this.unitString(this.megabytes(), "M");
            }
            if (this.kilobytes() >= 1.0) {
                return this.unitString(this.kilobytes(), "K");
            }
            return Long.toString(this.value) + " bytes";
        }
        return "N/A";
    }

    private String unitString(double value, String units) {
        return "" + units;
    }
}

