/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.pgsql.constants.DataType;
import de.bytefish.pgbulkinsert.pgsql.converter.IValueConverter;
import de.bytefish.pgbulkinsert.pgsql.converter.LocalDateConverter;
import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import java.io.DataOutputStream;
import java.time.LocalDate;

public class LocalDateValueHandler
extends BaseValueHandler<LocalDate> {
    private IValueConverter<LocalDate, Integer> dateConverter;

    public LocalDateValueHandler() {
        this(new LocalDateConverter());
    }

    public LocalDateValueHandler(IValueConverter<LocalDate, Integer> dateTimeConverter) {
        this.dateConverter = dateTimeConverter;
    }

    @Override
    protected void internalHandle(DataOutputStream buffer, LocalDate value) throws Exception {
        buffer.writeInt(4);
        buffer.writeInt(this.dateConverter.convert(value));
    }

    @Override
    public DataType getDataType() {
        return DataType.Date;
    }
}

