/*
 * Decompiled with CFR 0.152.
 */
package de.micromata.opengis.kml.v_2_2_0;

import de.micromata.opengis.kml.v_2_2_0.AbstractObject;
import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.BooleanConverter;
import de.micromata.opengis.kml.v_2_2_0.Coordinate;
import de.micromata.opengis.kml.v_2_2_0.CoordinatesConverter;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.annotations.Obvious;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PointType", propOrder={"extrude", "altitudeMode", "coordinates", "pointSimpleExtension", "pointObjectExtension"})
@XmlRootElement(name="Point", namespace="http://www.opengis.net/kml/2.2")
public class Point
extends Geometry
implements Cloneable {
    @XmlElement(defaultValue="0")
    @XmlJavaTypeAdapter(value=BooleanConverter.class)
    protected Boolean extrude;
    @XmlElement(defaultValue="clampToGround")
    protected AltitudeMode altitudeMode;
    @XmlElement(namespace="http://www.opengis.net/kml/2.2", type=String.class)
    @XmlJavaTypeAdapter(value=CoordinatesConverter.class)
    protected List<Coordinate> coordinates;
    @XmlElement(name="PointSimpleExtensionGroup")
    @XmlSchemaType(name="anySimpleType")
    protected List<Object> pointSimpleExtension;
    @XmlElement(name="PointObjectExtensionGroup")
    protected List<AbstractObject> pointObjectExtension;

    public Boolean isExtrude() {
        return this.extrude;
    }

    public void setExtrude(Boolean value) {
        this.extrude = value;
    }

    public AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(AltitudeMode value) {
        this.altitudeMode = value;
    }

    public List<Object> getPointSimpleExtension() {
        if (this.pointSimpleExtension == null) {
            this.pointSimpleExtension = new ArrayList<Object>();
        }
        return this.pointSimpleExtension;
    }

    public List<AbstractObject> getPointObjectExtension() {
        if (this.pointObjectExtension == null) {
            this.pointObjectExtension = new ArrayList<AbstractObject>();
        }
        return this.pointObjectExtension;
    }

    public List<Coordinate> getCoordinates() {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList<Coordinate>();
        }
        return this.coordinates;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.extrude == null ? 0 : this.extrude.hashCode());
        result = 31 * result + (this.altitudeMode == null ? 0 : this.altitudeMode.hashCode());
        result = 31 * result + (this.coordinates == null ? 0 : this.coordinates.hashCode());
        result = 31 * result + (this.pointSimpleExtension == null ? 0 : this.pointSimpleExtension.hashCode());
        result = 31 * result + (this.pointObjectExtension == null ? 0 : this.pointObjectExtension.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Point)) {
            return false;
        }
        Point other = (Point)obj;
        if (this.extrude == null ? other.extrude != null : !this.extrude.equals(other.extrude)) {
            return false;
        }
        if (this.altitudeMode == null ? other.altitudeMode != null : !this.altitudeMode.equals((Object)other.altitudeMode)) {
            return false;
        }
        if (this.coordinates == null ? other.coordinates != null : !this.coordinates.equals(other.coordinates)) {
            return false;
        }
        if (this.pointSimpleExtension == null ? other.pointSimpleExtension != null : !this.pointSimpleExtension.equals(other.pointSimpleExtension)) {
            return false;
        }
        return !(this.pointObjectExtension == null ? other.pointObjectExtension != null : !this.pointObjectExtension.equals(other.pointObjectExtension));
    }

    public void setCoordinates(List<Coordinate> coordinates) {
        this.coordinates = coordinates;
    }

    public Point addToCoordinates(double longitude, double latitude) {
        this.getCoordinates().add(new Coordinate(longitude, latitude));
        return this;
    }

    public Point addToCoordinates(double longitude, double latitude, double altitude) {
        this.getCoordinates().add(new Coordinate(longitude, latitude, altitude));
        return this;
    }

    public Point addToCoordinates(String coordinates) {
        this.getCoordinates().add(new Coordinate(coordinates));
        return this;
    }

    public void setPointSimpleExtension(List<Object> pointSimpleExtension) {
        this.pointSimpleExtension = pointSimpleExtension;
    }

    public Point addToPointSimpleExtension(Object pointSimpleExtension) {
        this.getPointSimpleExtension().add(pointSimpleExtension);
        return this;
    }

    public void setPointObjectExtension(List<AbstractObject> pointObjectExtension) {
        this.pointObjectExtension = pointObjectExtension;
    }

    public Point addToPointObjectExtension(AbstractObject pointObjectExtension) {
        this.getPointObjectExtension().add(pointObjectExtension);
        return this;
    }

    @Override
    @Obvious
    public void setObjectSimpleExtension(List<Object> objectSimpleExtension) {
        super.setObjectSimpleExtension(objectSimpleExtension);
    }

    @Override
    @Obvious
    public Point addToObjectSimpleExtension(Object objectSimpleExtension) {
        super.getObjectSimpleExtension().add(objectSimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public void setGeometrySimpleExtension(List<Object> geometrySimpleExtension) {
        super.setGeometrySimpleExtension(geometrySimpleExtension);
    }

    @Override
    @Obvious
    public Point addToGeometrySimpleExtension(Object geometrySimpleExtension) {
        super.getGeometrySimpleExtension().add(geometrySimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public void setGeometryObjectExtension(List<AbstractObject> geometryObjectExtension) {
        super.setGeometryObjectExtension(geometryObjectExtension);
    }

    @Override
    @Obvious
    public Point addToGeometryObjectExtension(AbstractObject geometryObjectExtension) {
        super.getGeometryObjectExtension().add(geometryObjectExtension);
        return this;
    }

    public Point withExtrude(Boolean extrude) {
        this.setExtrude(extrude);
        return this;
    }

    public Point withAltitudeMode(AltitudeMode altitudeMode) {
        this.setAltitudeMode(altitudeMode);
        return this;
    }

    public Point withCoordinates(List<Coordinate> coordinates) {
        this.setCoordinates(coordinates);
        return this;
    }

    public Point withPointSimpleExtension(List<Object> pointSimpleExtension) {
        this.setPointSimpleExtension(pointSimpleExtension);
        return this;
    }

    public Point withPointObjectExtension(List<AbstractObject> pointObjectExtension) {
        this.setPointObjectExtension(pointObjectExtension);
        return this;
    }

    @Override
    @Obvious
    public Point withObjectSimpleExtension(List<Object> objectSimpleExtension) {
        super.withObjectSimpleExtension((List)objectSimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public Point withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    @Obvious
    public Point withTargetId(String targetId) {
        super.withTargetId(targetId);
        return this;
    }

    @Override
    @Obvious
    public Point withGeometrySimpleExtension(List<Object> geometrySimpleExtension) {
        super.withGeometrySimpleExtension(geometrySimpleExtension);
        return this;
    }

    @Override
    @Obvious
    public Point withGeometryObjectExtension(List<AbstractObject> geometryObjectExtension) {
        super.withGeometryObjectExtension(geometryObjectExtension);
        return this;
    }

    public List<Coordinate> createAndSetCoordinates() {
        ArrayList<Coordinate> newValue = new ArrayList<Coordinate>();
        this.setCoordinates(newValue);
        return newValue;
    }

    @Override
    public Point clone() {
        Point copy = (Point)super.clone();
        copy.coordinates = new ArrayList<Coordinate>(this.getCoordinates().size());
        for (Coordinate coordinate : this.coordinates) {
            copy.coordinates.add(coordinate.clone());
        }
        copy.pointSimpleExtension = new ArrayList<Object>(this.getPointSimpleExtension().size());
        for (Object object : this.pointSimpleExtension) {
            copy.pointSimpleExtension.add(object);
        }
        copy.pointObjectExtension = new ArrayList<AbstractObject>(this.getPointObjectExtension().size());
        for (AbstractObject abstractObject : this.pointObjectExtension) {
            copy.pointObjectExtension.add(abstractObject.clone());
        }
        return copy;
    }
}

