/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis.ant;

import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.Logger;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.ant.BundledSignaturesType;
import de.thetaphi.forbiddenapis.ant.SignaturesResources;
import de.thetaphi.forbiddenapis.ant.SuppressAnnotationType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.types.resources.Union;

public class AntTask
extends Task
implements Constants {
    private final Union classFiles = new Union();
    private final Union apiSignatures = new Union();
    private final Collection<BundledSignaturesType> bundledSignatures = new LinkedHashSet<BundledSignaturesType>();
    private final Collection<SuppressAnnotationType> suppressAnnotations = new LinkedHashSet<SuppressAnnotationType>();
    private Path classpath = null;
    private boolean failOnUnsupportedJava = false;
    @Deprecated
    private boolean internalRuntimeForbidden = false;
    private boolean restrictClassFilename = true;
    private boolean failOnMissingClasses = true;
    private boolean failOnUnresolvableSignatures = true;
    private boolean failOnViolation = true;
    private boolean ignoreEmptyFileset = false;
    private String targetVersion = null;
    private boolean disableClassloadingCache = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Logger log = new Logger(){

            @Override
            public void error(String msg) {
                AntTask.this.log(msg, 0);
            }

            @Override
            public void warn(String msg) {
                AntTask.this.log("WARNING: " + msg, 1);
            }

            @Override
            public void info(String msg) {
                AntTask.this.log(msg, 2);
            }
        };
        AntClassLoader antLoader = null;
        try {
            Checker checker;
            block33: {
                block34: {
                    ClassLoader loader;
                    if (this.classpath != null) {
                        this.classpath.setProject(this.getProject());
                        antLoader = this.getProject().createClassLoader(ClassLoader.getSystemClassLoader(), this.classpath);
                        loader = antLoader;
                        antLoader.setParentFirst(true);
                    } else {
                        loader = ClassLoader.getSystemClassLoader();
                    }
                    this.classFiles.setProject(this.getProject());
                    this.apiSignatures.setProject(this.getProject());
                    EnumSet<Checker.Option> options = EnumSet.noneOf(Checker.Option.class);
                    if (this.failOnMissingClasses) {
                        options.add(Checker.Option.FAIL_ON_MISSING_CLASSES);
                    }
                    if (this.failOnViolation) {
                        options.add(Checker.Option.FAIL_ON_VIOLATION);
                    }
                    if (this.failOnUnresolvableSignatures) {
                        options.add(Checker.Option.FAIL_ON_UNRESOLVABLE_SIGNATURES);
                    }
                    if (this.disableClassloadingCache) {
                        options.add(Checker.Option.DISABLE_CLASSLOADING_CACHE);
                    }
                    checker = new Checker(log, loader, options);
                    if (!checker.isSupportedJDK) {
                        String msg = String.format(Locale.ENGLISH, "Your Java runtime (%s %s) is not supported by <%s/>. Please run the checks with a supported JDK!", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"), this.getTaskName());
                        if (this.failOnUnsupportedJava) {
                            throw new BuildException(msg);
                        }
                        log.warn(msg);
                        return;
                    }
                    for (SuppressAnnotationType a : this.suppressAnnotations) {
                        checker.addSuppressAnnotation(a.getClassname());
                    }
                    try {
                        for (BundledSignaturesType bs : this.bundledSignatures) {
                            String name = bs.getName();
                            if (name == null) {
                                throw new BuildException("<bundledSignatures/> must have the mandatory attribute 'name' referring to a bundled signatures file.");
                            }
                            String targetVersion = this.targetVersion;
                            if (bs.getTargetVersion() != null) {
                                if (!name.startsWith("jdk-")) {
                                    throw new ParseException("Cannot supply a targetVersion for non-JDK signatures.");
                                }
                                targetVersion = bs.getTargetVersion();
                            }
                            if (targetVersion == null && name.startsWith("jdk-")) {
                                log.warn("The 'targetVersion' parameter is missing. Trying to read bundled JDK signatures without compiler target. You have to explicitely specify the version in the resource name.");
                            }
                            checker.addBundledSignatures(name, targetVersion);
                        }
                        if (this.internalRuntimeForbidden) {
                            log.warn(DEPRECATED_WARN_INTERNALRUNTIME);
                            checker.addBundledSignatures("jdk-non-portable", null);
                        }
                        for (Resource r : this.apiSignatures) {
                            if (r instanceof StringResource) {
                                String s = ((StringResource)r).getValue();
                                if (s == null || s.trim().length() <= 0) continue;
                                checker.parseSignaturesString(s);
                                continue;
                            }
                            checker.parseSignaturesFile(r.getInputStream(), r.toString());
                        }
                    }
                    catch (IOException ioe) {
                        throw new BuildException("IO problem while reading files with API signatures: " + ioe.getMessage(), (Throwable)ioe);
                    }
                    catch (ParseException pe) {
                        throw new BuildException("Parsing signatures failed: " + pe.getMessage(), (Throwable)pe);
                    }
                    if (checker.hasNoSignatures()) {
                        throw new BuildException("No API signatures found; use signaturesFile=, <signatures*/>, <bundledSignatures/> or inner text to define those!");
                    }
                    log.info("Loading classes to check...");
                    try {
                        Iterator iter = this.classFiles.iterator();
                        boolean foundClass = false;
                        while (iter.hasNext()) {
                            Resource r = (Resource)iter.next();
                            String name = r.getName();
                            if (this.restrictClassFilename && name != null && !name.endsWith(".class")) continue;
                            checker.addClassToCheck(r.getInputStream(), r.getName());
                            foundClass = true;
                        }
                        if (foundClass) break block33;
                        if (!this.ignoreEmptyFileset) break block34;
                        log.warn("There is no <fileset/> or other resource collection given, or the collection does not contain any class files to check.");
                        log.info("Scanned 0 class files.");
                        return;
                    }
                    catch (IOException ioe) {
                        throw new BuildException("Failed to load one of the given class files: " + ioe.getMessage(), (Throwable)ioe);
                    }
                }
                throw new BuildException("There is no <fileset/> or other resource collection given, or the collection does not contain any class files to check.");
            }
            try {
                checker.run();
            }
            catch (ForbiddenApiException fae) {
                throw new BuildException(fae.getMessage(), fae.getCause());
            }
        }
        finally {
            if (antLoader != null) {
                antLoader.cleanup();
            }
        }
    }

    public void add(ResourceCollection rc) {
        this.classFiles.add(rc);
    }

    public void setDir(File dir) {
        FileSet fs = new FileSet();
        fs.setProject(this.getProject());
        fs.setDir(dir);
        fs.setIncludes("**/*.class");
        this.classFiles.add((ResourceCollection)fs);
    }

    private <T extends ProjectComponent> T addSignaturesResource(T res) {
        res.setProject(this.getProject());
        this.apiSignatures.add((ResourceCollection)res);
        return res;
    }

    public FileSet createSignaturesFileSet() {
        return this.addSignaturesResource(new FileSet());
    }

    public FileList createSignaturesFileList() {
        return this.addSignaturesResource(new FileList());
    }

    public FileResource createSignaturesFile() {
        return this.addSignaturesResource(new FileResource());
    }

    public SignaturesResources createSignatures() {
        return this.addSignaturesResource(new SignaturesResources(this));
    }

    public void setSignaturesFile(File file) {
        this.createSignaturesFile().setFile(file);
    }

    public void addText(String text) {
        this.addSignaturesResource(new StringResource(text));
    }

    public BundledSignaturesType createBundledSignatures() {
        BundledSignaturesType s = new BundledSignaturesType();
        s.setProject(this.getProject());
        this.bundledSignatures.add(s);
        return s;
    }

    public void setBundledSignatures(String name) {
        this.createBundledSignatures().setName(name);
    }

    public SuppressAnnotationType createSuppressAnnotation() {
        SuppressAnnotationType s = new SuppressAnnotationType();
        s.setProject(this.getProject());
        this.suppressAnnotations.add(s);
        return s;
    }

    public void setSuppressAnnotation(String classname) {
        this.createSuppressAnnotation().setClassname(classname);
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setFailOnUnsupportedJava(boolean failOnUnsupportedJava) {
        this.failOnUnsupportedJava = failOnUnsupportedJava;
    }

    public void setFailOnMissingClasses(boolean failOnMissingClasses) {
        this.failOnMissingClasses = failOnMissingClasses;
    }

    public void setFailOnUnresolvableSignatures(boolean failOnUnresolvableSignatures) {
        this.failOnUnresolvableSignatures = failOnUnresolvableSignatures;
    }

    @Deprecated
    public void setInternalRuntimeForbidden(boolean internalRuntimeForbidden) {
        this.internalRuntimeForbidden = internalRuntimeForbidden;
    }

    public void setRestrictClassFilename(boolean restrictClassFilename) {
        this.restrictClassFilename = restrictClassFilename;
    }

    public void setIgnoreEmptyFileSet(boolean ignoreEmptyFileset) {
        this.ignoreEmptyFileset = ignoreEmptyFileset;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public void setDisableClassloadingCache(boolean disableClassloadingCache) {
        this.disableClassloadingCache = disableClassloadingCache;
    }
}

