/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.profiler.sorting.time;

import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.Map;

class ProjectsSorter {
    private ProjectsSorter() {
    }

    public static <T> List<T> byExecutionTime(Map<T, Stopwatch> projects) {
        Ordering descending = new Ordering<Map.Entry<T, Stopwatch>>(){

            public int compare(Map.Entry<T, Stopwatch> left, Map.Entry<T, Stopwatch> right) {
                return Longs.compare((long)right.getValue().elapsedMillis(), (long)left.getValue().elapsedMillis());
            }
        };
        return Lists.transform((List)descending.sortedCopy(projects.entrySet()), (Function)new Function<Map.Entry<T, Stopwatch>, T>(){

            public T apply(Map.Entry<T, Stopwatch> input) {
                return input.getKey();
            }
        });
    }
}

