/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration;

import io.agroal.api.cache.ConnectionCache;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.transaction.TransactionIntegration;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;

public interface AgroalConnectionPoolConfiguration {
    public AgroalConnectionFactoryConfiguration connectionFactoryConfiguration();

    public ConnectionValidator connectionValidator();

    public ExceptionSorter exceptionSorter();

    public ConnectionCache connectionCache();

    public TransactionIntegration transactionIntegration();

    public TransactionRequirement transactionRequirement();

    public Duration idleValidationTimeout();

    public Duration leakTimeout();

    public Duration validationTimeout();

    public Duration reapTimeout();

    public Duration maxLifetime();

    public boolean enhancedLeakReport();

    public boolean flushOnClose();

    public MultipleAcquisitionAction multipleAcquisition();

    public int initialSize();

    public int minSize();

    public void setMinSize(int var1);

    public int maxSize();

    public void setMaxSize(int var1);

    public Duration acquisitionTimeout();

    public void setAcquisitionTimeout(Duration var1);

    public static interface ExceptionSorter {
        public static ExceptionSorter defaultExceptionSorter() {
            return new ExceptionSorter(){

                @Override
                public boolean isFatal(SQLException se) {
                    return false;
                }
            };
        }

        public static ExceptionSorter emptyExceptionSorter() {
            return new ExceptionSorter(){

                @Override
                public boolean isFatal(SQLException se) {
                    return false;
                }
            };
        }

        public static ExceptionSorter fatalExceptionSorter() {
            return new ExceptionSorter(){

                @Override
                public boolean isFatal(SQLException se) {
                    return true;
                }
            };
        }

        public boolean isFatal(SQLException var1);
    }

    public static interface ConnectionValidator {
        public static ConnectionValidator defaultValidator() {
            return new ConnectionValidator(){

                @Override
                public boolean isValid(Connection connection) {
                    try {
                        return connection.isValid(0);
                    }
                    catch (Exception t) {
                        return false;
                    }
                }
            };
        }

        public static ConnectionValidator defaultValidatorWithTimeout(final int timeout) {
            return new ConnectionValidator(){

                @Override
                public boolean isValid(Connection connection) {
                    try {
                        return connection.isValid(timeout);
                    }
                    catch (Exception t) {
                        return false;
                    }
                }
            };
        }

        public static ConnectionValidator emptyValidator() {
            return new ConnectionValidator(){

                @Override
                public boolean isValid(Connection connection) {
                    return true;
                }
            };
        }

        public boolean isValid(Connection var1);
    }

    public static enum MultipleAcquisitionAction {
        OFF,
        WARN,
        STRICT;

    }

    public static enum TransactionRequirement {
        OFF,
        WARN,
        STRICT;

    }
}

