/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver.strategy;

import io.apicurio.registry.resolver.strategy.ArtifactReference;

public class ArtifactCoordinates {
    private String groupId;
    private String artifactId;
    private String version;

    protected ArtifactCoordinates() {
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    protected void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    protected void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactCoordinates other = (ArtifactCoordinates)obj;
        if (this.groupId != null && other.groupId != null && !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId != null && other.artifactId != null && !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.version != null && other.version != null) {
            return this.version.equals(other.version);
        }
        return true;
    }

    public String toString() {
        return "ArtifactCoordinates [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
    }

    public static ArtifactCoordinates fromArtifactReference(ArtifactReference artifactReference) {
        return ArtifactCoordinates.builder().artifactId(artifactReference.getArtifactId()).groupId(artifactReference.getGroupId()).version(artifactReference.getVersion()).build();
    }

    public static ArtifactCoordinatesBuilder builder() {
        return new ArtifactCoordinatesBuilder();
    }

    public static class ArtifactCoordinatesBuilder {
        private ArtifactCoordinates coordinates = new ArtifactCoordinates();

        public ArtifactCoordinatesBuilder groupId(String groupId) {
            this.coordinates.setGroupId(groupId);
            return this;
        }

        public ArtifactCoordinatesBuilder artifactId(String artifactId) {
            this.coordinates.setArtifactId(artifactId);
            return this;
        }

        public ArtifactCoordinatesBuilder version(String version) {
            this.coordinates.setVersion(version);
            return this;
        }

        public ArtifactCoordinates build() {
            return this.coordinates;
        }
    }
}

