/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.LocalDateTimeArgument;
import java.time.LocalDateTime;
import java.util.Optional;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalLocalDateTimeArgumentFactory
implements ArgumentFactory<Optional<LocalDateTime>> {
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof LocalDateTime;
        }
        return false;
    }

    public Argument build(Class<?> expectedType, Optional<LocalDateTime> value, StatementContext ctx) {
        return new LocalDateTimeArgument(value.get());
    }
}

