/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.visualize;

import java.io.PrintStream;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;
import org.checkerframework.errorprone.dataflow.analysis.Analysis;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.analysis.TransferFunction;
import org.checkerframework.errorprone.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.errorprone.dataflow.cfg.block.Block;
import org.checkerframework.errorprone.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.errorprone.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.errorprone.dataflow.cfg.visualize.AbstractCFGVisualizer;
import org.checkerframework.errorprone.dataflow.expression.ArrayAccess;
import org.checkerframework.errorprone.dataflow.expression.ClassName;
import org.checkerframework.errorprone.dataflow.expression.FieldAccess;
import org.checkerframework.errorprone.dataflow.expression.LocalVariable;
import org.checkerframework.errorprone.dataflow.expression.MethodCall;

public class StringCFGVisualizer<V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>>
extends AbstractCFGVisualizer<V, S, T> {
    protected PrintStream out = System.out;

    @Override
    public void init(Map<String, Object> args) {
        super.init(args);
        PrintStream argout = (PrintStream)args.get("output");
        if (argout != null) {
            this.out = argout;
        }
    }

    @Override
    public String getSeparator() {
        return "\n";
    }

    @Override
    public Map<String, Object> visualize(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        String stringGraph = this.visualizeGraph(cfg, entry, analysis);
        return Collections.singletonMap("stringGraph", stringGraph);
    }

    @Override
    public Map<String, Object> visualizeWithAction(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        Map<String, Object> vis = this.visualize(cfg, entry, analysis);
        String stringGraph = (String)vis.get("stringGraph");
        this.out.println(stringGraph);
        return vis;
    }

    @Override
    public String visualizeNodes(Set<Block> blocks, ControlFlowGraph cfg, @Nullable Analysis<V, S, T> analysis) {
        StringJoiner sjStringNodes = new StringJoiner(lineSeparator);
        IdentityHashMap<Block, List<Integer>> processOrder = this.getProcessOrder(cfg);
        for (Block v : blocks) {
            sjStringNodes.add(v.getUid() + ":");
            if (this.verbose) {
                sjStringNodes.add(this.getProcessOrderSimpleString(processOrder.get(v)));
            }
            sjStringNodes.add(this.visualizeBlock(v, analysis));
            sjStringNodes.add("");
        }
        return sjStringNodes.toString().trim();
    }

    @Override
    protected String visualizeEdge(Object sId, Object eId, String flowRule) {
        if (this.verbose) {
            return sId + " -> " + eId + " " + flowRule;
        }
        return sId + " -> " + eId;
    }

    @Override
    public String visualizeBlock(Block bb, @Nullable Analysis<V, S, T> analysis) {
        return super.visualizeBlockHelper(bb, analysis, lineSeparator).trim();
    }

    @Override
    public String visualizeSpecialBlock(SpecialBlock sbb) {
        return super.visualizeSpecialBlockHelper(sbb);
    }

    @Override
    public String visualizeConditionalBlock(ConditionalBlock cbb) {
        return "ConditionalBlock: then: " + cbb.getThenSuccessor().getUid() + ", else: " + cbb.getElseSuccessor().getUid();
    }

    @Override
    public String visualizeBlockTransferInputBefore(Block bb, Analysis<V, S, T> analysis) {
        return super.visualizeBlockTransferInputHelper(AbstractCFGVisualizer.VisualizeWhere.BEFORE, bb, analysis, lineSeparator);
    }

    @Override
    public String visualizeBlockTransferInputAfter(Block bb, Analysis<V, S, T> analysis) {
        return super.visualizeBlockTransferInputHelper(AbstractCFGVisualizer.VisualizeWhere.AFTER, bb, analysis, lineSeparator);
    }

    @Override
    protected String format(Object obj) {
        return obj.toString();
    }

    @Override
    public String visualizeStoreThisVal(V value) {
        return "  this > " + value;
    }

    @Override
    public String visualizeStoreLocalVar(LocalVariable localVar, V value) {
        return "  " + localVar + " > " + value;
    }

    @Override
    public String visualizeStoreFieldVal(FieldAccess fieldAccess, V value) {
        return "  " + fieldAccess + " > " + value;
    }

    @Override
    public String visualizeStoreArrayVal(ArrayAccess arrayValue, V value) {
        return "  " + arrayValue + " > " + value;
    }

    @Override
    public String visualizeStoreMethodVals(MethodCall methodCall, V value) {
        return "  " + methodCall + " > " + value;
    }

    @Override
    public String visualizeStoreClassVals(ClassName className, V value) {
        return "  " + className + " > " + value;
    }

    @Override
    public String visualizeStoreKeyVal(String keyName, Object value) {
        return "  " + keyName + " = " + value;
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected String visualizeGraphHeader() {
        return "";
    }

    @Override
    protected String visualizeGraphFooter() {
        return "";
    }
}

