/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.dynamodb.runtime;

import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.dynamodb.runtime.DynamodbConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@Recorder
public class DynamodbRecorder
extends AmazonClientRecorder {
    final DynamodbConfig config;

    public DynamodbRecorder(DynamodbConfig config) {
        this.config = config;
    }

    public RuntimeValue<AwsConfig> getAwsConfig() {
        return new RuntimeValue((Object)this.config.aws());
    }

    public RuntimeValue<SdkConfig> getSdkConfig() {
        return new RuntimeValue((Object)this.config.sdk());
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return this.config.asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return this.config.syncClient();
    }

    public AwsSyncClientBuilder<?, ?> geSyncClientBuilder() {
        return DynamoDbClient.builder();
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        return DynamoDbAsyncClient.builder();
    }
}

