/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.freemarker.runtime;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import io.quarkiverse.freemarker.runtime.FreemarkerBuildConfigSupport;
import io.quarkiverse.freemarker.runtime.FreemarkerConfig;
import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

@Singleton
public class FreemarkerConfigurationProducer {
    private static final Logger LOGGER = Logger.getLogger(FreemarkerConfigurationProducer.class);

    @DefaultBean
    @Singleton
    @Produces
    public Configuration configuration(FreemarkerBuildConfigSupport freemarkerBuildConfigSupport, FreemarkerConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_31);
        ArrayList loaders = new ArrayList();
        LOGGER.debugf("Adding build time locations: %s", freemarkerBuildConfigSupport.getResourcePaths());
        freemarkerBuildConfigSupport.getResourcePaths().stream().map(this::newClassTemplateLoader).forEach(loaders::add);
        LOGGER.debugf("Adding runtime locations: %s", config.filePaths.orElse(Collections.emptyList()));
        loaders.addAll(config.filePaths.orElse(Collections.emptyList()).stream().map(this::newFileTemplateLoader).collect(Collectors.toList()));
        MultiTemplateLoader mtl = new MultiTemplateLoader(loaders.toArray(new TemplateLoader[0]));
        cfg.setTemplateLoader((TemplateLoader)mtl);
        config.defaultEncoding.ifPresent(arg_0 -> ((Configuration)cfg).setDefaultEncoding(arg_0));
        config.templateExceptionHandler.ifPresent(s -> cfg.setTemplateExceptionHandler(this.getExceptionHandler((String)s)));
        config.logTemplateExceptions.ifPresent(arg_0 -> ((Configuration)cfg).setLogTemplateExceptions(arg_0));
        config.wrapUncheckedExceptions.ifPresent(arg_0 -> ((Configuration)cfg).setWrapUncheckedExceptions(arg_0));
        config.fallbackOnNullLoopVariable.ifPresent(arg_0 -> ((Configuration)cfg).setFallbackOnNullLoopVariable(arg_0));
        config.booleanFormat.ifPresent(arg_0 -> ((Configuration)cfg).setBooleanFormat(arg_0));
        config.numberFormat.ifPresent(arg_0 -> ((Configuration)cfg).setNumberFormat(arg_0));
        if (config.objectWrapperExposeFields.isPresent()) {
            DefaultObjectWrapper objectWrapper = new DefaultObjectWrapper(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            objectWrapper.setExposeFields(config.objectWrapperExposeFields.get().booleanValue());
            cfg.setObjectWrapper((ObjectWrapper)objectWrapper);
        }
        for (Map.Entry<String, String> directive : freemarkerBuildConfigSupport.getDirectives().entrySet()) {
            Class<?> directiveClass = Thread.currentThread().getContextClassLoader().loadClass(directive.getValue());
            cfg.setSharedVariable(directive.getKey(), (TemplateModel)((TemplateDirectiveModel)directiveClass.newInstance()));
        }
        return cfg;
    }

    private TemplateExceptionHandler getExceptionHandler(String templateExceptionHandler) {
        if (templateExceptionHandler.equals("rethrow")) {
            return TemplateExceptionHandler.RETHROW_HANDLER;
        }
        if (templateExceptionHandler.equals("debug")) {
            return TemplateExceptionHandler.DEBUG_HANDLER;
        }
        if (templateExceptionHandler.equals("html-debug")) {
            return TemplateExceptionHandler.HTML_DEBUG_HANDLER;
        }
        if (templateExceptionHandler.equals("ignore")) {
            return TemplateExceptionHandler.IGNORE_HANDLER;
        }
        return null;
    }

    private ClassTemplateLoader newClassTemplateLoader(String location) {
        return new ClassTemplateLoader(Thread.currentThread().getContextClassLoader(), "/" + location);
    }

    private FileTemplateLoader newFileTemplateLoader(String path) {
        try {
            return new FileTemplateLoader(new File(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

