/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.AnnotationSet;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.PackageInfo;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;

class PackageInfoImpl
implements PackageInfo {
    final IndexView jandexIndex;
    final AllAnnotationOverlays annotationOverlays;
    final ClassInfo jandexDeclaration;
    private AnnotationSet annotationSet;

    PackageInfoImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, ClassInfo jandexDeclaration) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
        this.jandexDeclaration = jandexDeclaration;
    }

    public String name() {
        return this.jandexDeclaration.name().packagePrefix();
    }

    private AnnotationSet annotationSet() {
        if (this.annotationSet == null) {
            this.annotationSet = new AnnotationSet(this.jandexDeclaration.declaredAnnotations());
        }
        return this.annotationSet;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotationSet().hasAnnotation(annotationType);
    }

    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        return this.annotationSet().annotations().stream().anyMatch(it -> predicate.test(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)));
    }

    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        AnnotationInstance jandexAnnotation = this.annotationSet().annotation(annotationType);
        if (jandexAnnotation == null) {
            return null;
        }
        return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, jandexAnnotation);
    }

    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        return this.annotationSet().annotationsWithRepeatable(annotationType).stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)).collect(Collectors.toUnmodifiableList());
    }

    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        return this.annotationSet().annotations().stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)).filter(predicate).collect(Collectors.toUnmodifiableList());
    }

    public Collection<AnnotationInfo> annotations() {
        return this.annotations(it -> true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageInfoImpl that = (PackageInfoImpl)o;
        return Objects.equals(this.jandexDeclaration.name(), that.jandexDeclaration.name());
    }

    public int hashCode() {
        return Objects.hash(this.jandexDeclaration.name());
    }
}

