/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client;

import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.client.RegistryCache;
import io.quarkus.registry.client.RegistryClient;
import io.quarkus.registry.client.RegistryNonPlatformExtensionsResolver;
import io.quarkus.registry.client.RegistryPlatformExtensionsResolver;
import io.quarkus.registry.client.RegistryPlatformsResolver;
import io.quarkus.registry.config.RegistryConfig;
import java.util.Objects;

public class RegistryClientDispatcher
implements RegistryClient {
    private final RegistryPlatformsResolver platforms;
    private final RegistryPlatformExtensionsResolver platformExtensions;
    private final RegistryNonPlatformExtensionsResolver nonPlatformExtensions;
    private final RegistryCache registryCache;
    protected RegistryConfig config;

    public RegistryClientDispatcher(RegistryConfig config, RegistryPlatformsResolver platforms, RegistryPlatformExtensionsResolver platformExtensions, RegistryNonPlatformExtensionsResolver nonPlatformExtensions) {
        this(config, platforms, platformExtensions, nonPlatformExtensions, null);
    }

    public RegistryClientDispatcher(RegistryConfig config, RegistryPlatformsResolver platforms, RegistryPlatformExtensionsResolver platformExtensions, RegistryNonPlatformExtensionsResolver nonPlatformExtensions, RegistryCache registryCache) {
        this.config = config;
        this.platforms = platforms;
        this.platformExtensions = Objects.requireNonNull(platformExtensions);
        this.nonPlatformExtensions = nonPlatformExtensions;
        this.registryCache = registryCache;
    }

    @Override
    public PlatformCatalog resolvePlatforms(String quarkusVersion) throws RegistryResolutionException {
        return this.platforms == null ? null : this.platforms.resolvePlatforms(quarkusVersion);
    }

    @Override
    public ExtensionCatalog resolvePlatformExtensions(ArtifactCoords platformCoords) throws RegistryResolutionException {
        return this.platformExtensions.resolvePlatformExtensions(platformCoords);
    }

    @Override
    public ExtensionCatalog resolveNonPlatformExtensions(String quarkusVersion) throws RegistryResolutionException {
        return this.nonPlatformExtensions == null ? null : this.nonPlatformExtensions.resolveNonPlatformExtensions(quarkusVersion);
    }

    @Override
    public RegistryConfig resolveRegistryConfig() throws RegistryResolutionException {
        return this.config;
    }

    @Override
    public void clearCache() throws RegistryResolutionException {
        if (this.registryCache != null) {
            this.registryCache.clearCache();
        }
    }
}

