/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.runtime.test.TestHttpEndpointProvider;
import io.quarkus.test.common.NativeImageLauncher;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.RestAssuredURLManager;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.TestScopeManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.NativeImageTest;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.TestProfile;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.JUnitException;

public class NativeTestExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
TestInstancePostProcessor {
    private static boolean failedBoot;
    private static List<Function<Class<?>, String>> testHttpEndpointProviders;
    private static boolean ssl;

    public void afterEach(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            RestAssuredURLManager.clearURL();
            TestScopeManager.tearDown((boolean)true);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (!failedBoot) {
            RestAssuredURLManager.setURL((boolean)ssl, (String)QuarkusTestExtension.getEndpointPath(context, testHttpEndpointProviders));
            TestScopeManager.setup((boolean)true);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        Class testClass = extensionContext.getRequiredTestClass();
        this.ensureNoInjectAnnotationIsUsed(testClass);
        ExtensionContext root = extensionContext.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        ExtensionState state = (ExtensionState)store.get((Object)ExtensionState.class.getName(), ExtensionState.class);
        PropertyTestUtil.setLogFileProperty();
        if (state == null) {
            this.ensureNoTestProfile(testClass);
            TestResourceManager testResourceManager = new TestResourceManager(testClass);
            try {
                testResourceManager.init();
                Map systemProps = testResourceManager.start();
                NativeImageLauncher launcher = new NativeImageLauncher(testClass);
                launcher.addSystemProperties(systemProps);
                try {
                    launcher.start();
                }
                catch (IOException e) {
                    try {
                        launcher.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw e;
                }
                if (launcher.isDefaultSsl()) {
                    ssl = true;
                }
                state = new ExtensionState(testResourceManager, (Closeable)launcher, true);
                store.put((Object)ExtensionState.class.getName(), (Object)state);
                testHttpEndpointProviders = TestHttpEndpointProvider.load();
            }
            catch (Exception e) {
                failedBoot = true;
                throw new JUnitException("Quarkus native image start failed, original cause: " + e, (Throwable)e);
            }
        }
    }

    private void ensureNoInjectAnnotationIsUsed(Class<?> testClass) {
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation == null) continue;
                throw new JUnitException("@Inject is not supported in NativeImageTest tests. Offending field is " + field.getDeclaringClass().getTypeName() + "." + field.getName());
            }
            current = current.getSuperclass();
        }
    }

    private void ensureNoTestProfile(Class<?> testClass) {
        Index index = TestClassIndexer.readIndex(testClass);
        List instances = index.getAnnotations(DotName.createSimple((String)NativeImageTest.class.getName()));
        for (AnnotationInstance instance : instances) {
            ClassInfo testClassInfo;
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS || (testClassInfo = instance.target().asClass()).classAnnotation(DotName.createSimple((String)TestProfile.class.getName())) == null) continue;
            throw new JUnitException("@TestProfile is not supported in NativeImageTest tests. Offending class is " + testClassInfo.name());
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        TestHTTPResourceManager.inject((Object)testInstance);
        ExtensionContext root = context.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        ExtensionState state = (ExtensionState)store.get((Object)ExtensionState.class.getName(), ExtensionState.class);
        state.testResourceManager.inject(testInstance);
    }

    public class ExtensionState
    implements ExtensionContext.Store.CloseableResource {
        private final TestResourceManager testResourceManager;
        private final Closeable resource;

        ExtensionState(TestResourceManager testResourceManager, Closeable resource, boolean nativeImage) {
            this.testResourceManager = testResourceManager;
            this.resource = resource;
        }

        public void close() throws Throwable {
            this.testResourceManager.close();
            this.resource.close();
        }
    }
}

