/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.smallrye.mutiny.Multi;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiSupport {
    private MultiSupport() {
    }

    public static void subscribeVoid(Multi<Void> multi, final RoutingContext rc) {
        final HttpServerResponse response = rc.response();
        multi.subscribe().with((Consumer)new Consumer<Void>(){

            @Override
            public void accept(Void item) {
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable failure) {
                rc.fail(failure);
            }
        }, new Runnable(){

            @Override
            public void run() {
                response.setStatusCode(204).end();
            }
        });
    }

    public static void subscribeString(Multi<String> multi, RoutingContext rc) {
        MultiSupport.subscribeBuffer((Multi<Buffer>)multi.map(s -> Buffer.buffer((String)s)), rc);
    }

    private static void onWriteDone(Subscription subscription, AsyncResult<Void> ar, RoutingContext rc) {
        if (ar.failed()) {
            rc.fail(ar.cause());
        } else {
            subscription.request(1L);
        }
    }

    public static void subscribeBuffer(Multi<Buffer> multi, final RoutingContext rc) {
        final HttpServerResponse response = rc.response();
        multi.subscribe().withSubscriber((Subscriber)new Subscriber<Buffer>(){
            Subscription upstream;

            public void onSubscribe(Subscription subscription) {
                this.upstream = subscription;
                response.setChunked(true);
                this.upstream.request(1L);
            }

            public void onNext(Buffer item) {
                response.write((Object)item, (Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> ar) {
                        MultiSupport.onWriteDone(upstream, ar, rc);
                    }
                });
            }

            public void onError(Throwable throwable) {
                rc.fail(throwable);
            }

            public void onComplete() {
                if (response.bytesWritten() == 0L) {
                    response.setStatusCode(204);
                }
                response.end();
            }
        });
    }

    public static void subscribeMutinyBuffer(Multi<io.vertx.mutiny.core.buffer.Buffer> multi, RoutingContext rc) {
        MultiSupport.subscribeBuffer((Multi<Buffer>)multi.map((Function)new Function<io.vertx.mutiny.core.buffer.Buffer, Buffer>(){

            @Override
            public Buffer apply(io.vertx.mutiny.core.buffer.Buffer b) {
                return b.getDelegate();
            }
        }), rc);
    }

    public static void subscribeObject(Multi<Object> multi, RoutingContext rc) {
        MultiSupport.subscribeBuffer((Multi<Buffer>)multi.map((Function)new Function<Object, Buffer>(){

            @Override
            public Buffer apply(Object o) {
                return Json.encodeToBuffer((Object)o);
            }
        }), rc);
    }
}

